/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.KeyboardFocusManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.swing.Icon;
import kz.pandev.plugins.metrics.c.e;
import kz.pandev.plugins.metrics.c.f;
import kz.pandev.plugins.metrics.clients.ApiClient;
import kz.pandev.plugins.metrics.configs.c;
import kz.pandev.plugins.metrics.d.j;
import kz.pandev.plugins.metrics.listeners.b;
import kz.pandev.plugins.metrics.listeners.d;
import kz.pandev.plugins.metrics.models.Heartbeat;
import kz.pandev.plugins.metrics.models.LineStatistics;
import kz.pandev.plugins.metrics.models.enums.ProjectStatus;
import kz.pandev.plugins.metrics.widgets.a;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.http.HttpException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PanDevMetrics
implements ApplicationComponent {
    public static final BigDecimal FREQUENCY = new BigDecimal(120);
    public static final Logger log = LogManager.getLogger(PanDevMetrics.class);
    private static final Map<String, LineStatistics> lineStatisticsCache = new HashMap<String, LineStatistics>();
    public static String VERSION;
    public static String IDE_VERSION;
    private static MessageBusConnection connection;
    private static String lastFile;
    private static BigDecimal lastTime;
    private static final Boolean IS_BUILDING;
    private static boolean isLoginPageCanceled;
    private static boolean isSettingsWindowOpen;
    private static final ScheduledExecutorService scheduler;
    private static final Gson GSON;
    private static ScheduledFuture<?> scheduledFixture;
    public static boolean isVersionChecked;
    private static BigDecimal todayTextTime;

    public static Icon getLogoIcon() {
        String string = JBColor.isBright() ? "light" : "dark";
        return IconLoader.getIcon((String)("images/icons/status-bar-icon-" + string + "-theme.svg"), PanDevMetrics.class);
    }

    public void initComponent() {
        connection = ApplicationManager.getApplication().getMessageBus().connect();
        VERSION = Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"kz.pandev.intellij.plugin"))).getVersion();
        IDE_VERSION = ApplicationInfo.getInstance().getFullApplicationName();
        String string = "Initializing PanDev Metrics plugin v%s".formatted(VERSION);
        log.info(string);
        kz.pandev.plugins.metrics.b.b.a();
        PanDevMetrics.initStatusBar();
        this.initEventListeners();
        PanDevMetrics.initQueueProcessor();
        kz.pandev.plugins.metrics.actions.a.a();
        kz.pandev.plugins.metrics.actions.b.a();
        kz.pandev.plugins.metrics.a.a.a();
    }

    public static void initStatusBar() {
        PanDevMetrics.updateStatusBarText();
    }

    private void initEventListeners() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Disposable disposable = Disposer.newDisposable((String)"PanDevMetricsListener");
            connection.subscribe(FileDocumentManagerListener.TOPIC, (Object)new d());
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new kz.pandev.plugins.metrics.listeners.a(), disposable);
            EditorFactory.getInstance().getEventMulticaster().addEditorMouseListener((EditorMouseListener)new kz.pandev.plugins.metrics.listeners.c(), disposable);
            EditorFactory.getInstance().getEventMulticaster().addVisibleAreaListener((VisibleAreaListener)new kz.pandev.plugins.metrics.listeners.e(), disposable);
            EditorFactory.getInstance().getEventMulticaster().addCaretListener((CaretListener)new b(), disposable);
        });
    }

    private static void initQueueProcessor() {
        Runnable runnable = PanDevMetrics::processHeartbeatQueue;
        long l2 = 30L;
        scheduledFixture = scheduler.scheduleAtFixedRate(runnable, l2, l2, TimeUnit.SECONDS);
    }

    public void disposeComponent() {
        try {
            connection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            scheduledFixture.cancel(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PanDevMetrics.processHeartbeatQueue();
    }

    public static void checkIsConfigured() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = PanDevMetrics.getCurrentProject();
            if (project == null) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode() || !application.isDispatchThread()) {
                return;
            }
            Collection<c> collection = kz.pandev.plugins.metrics.b.b.d();
            PanDevMetrics.validateServerSettingsAndShowAddServerDialogIfNotValid(collection, project);
        });
    }

    private static void validateServerSettingsAndShowAddServerDialogIfNotValid(Collection<c> collection, Project project) {
        if (collection.isEmpty()) {
            if (isLoginPageCanceled || isSettingsWindowOpen) {
                return;
            }
            e e2 = new e(project);
            e2.c();
        } else {
            for (c c2 : collection) {
                if (!c2.f()) {
                    if (isLoginPageCanceled || isSettingsWindowOpen) continue;
                    try {
                        f f2 = new f(project, c2);
                        f2.show();
                    }
                    catch (Exception exception) {
                        PanDevMetrics.warnException(exception);
                    }
                    continue;
                }
                if (isVersionChecked) continue;
                isVersionChecked = true;
                log.info("Requested to get version from server");
                j.a(c2.g());
            }
        }
    }

    public static BigDecimal getCurrentTimestamp() {
        return new BigDecimal(String.valueOf((double)System.currentTimeMillis() / 1000.0)).setScale(4, RoundingMode.HALF_UP);
    }

    public static void appendHeartbeat(VirtualFile virtualFile, Project project, boolean bl, @Nullable LineStatistics lineStatistics) {
        String string;
        PanDevMetrics.updateStatusBarText();
        if (!PanDevMetrics.shouldLogFile(virtualFile)) {
            return;
        }
        BigDecimal bigDecimal = PanDevMetrics.getCurrentTimestamp();
        if (!bl && virtualFile.getPath().equals(lastFile) && !PanDevMetrics.enoughTimePassed(bigDecimal)) {
            return;
        }
        lastFile = virtualFile.getPath();
        lastTime = bigDecimal;
        String string2 = null;
        String string3 = null;
        Module module = PanDevMetrics.getCurrentModule(project, virtualFile);
        if (module != null) {
            string2 = module.getName();
            string3 = kz.pandev.plugins.metrics.d.c.b(module);
        }
        String string4 = project.getBasePath();
        String string5 = string2 != null ? string2 : project.getName();
        String string6 = project.getName();
        String string7 = PanDevMetrics.getRelativePath(project, virtualFile);
        String string8 = PanDevMetrics.getFileLanguage(virtualFile);
        String[] stringArray = kz.pandev.plugins.metrics.d.c.a(string4);
        String string9 = string = stringArray.length > 0 ? stringArray[0] : null;
        String string10 = Objects.nonNull(string3) ? string3 : (stringArray.length > 1 ? stringArray[1] : null);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Heartbeat heartbeat = new Heartbeat();
            heartbeat.setTimestamp(bigDecimal);
            heartbeat.setProject(string6);
            heartbeat.setFilePath(string7);
            heartbeat.setModule(string5);
            heartbeat.setLanguage(string8);
            heartbeat.setGitBranch(string10);
            heartbeat.setGitPath(string);
            heartbeat.setFileName(virtualFile.getName());
            heartbeat.setIde(IDE_VERSION);
            heartbeat.setLineCount(lineStatistics.getLineCount());
            heartbeat.setLineNumber(lineStatistics.getLineNumber());
            heartbeat.setCursorPosition(lineStatistics.getCursorPosition());
            for (c c2 : kz.pandev.plugins.metrics.b.b.d()) {
                c2.b().add(heartbeat);
            }
            if (Boolean.TRUE.equals(IS_BUILDING)) {
                PanDevMetrics.setBuildTimeout();
            }
        });
    }

    private static void setBuildTimeout() {
        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
            if (Boolean.FALSE.equals(IS_BUILDING)) {
                return;
            }
            Project project = PanDevMetrics.getCurrentProject();
            if (project == null) {
                return;
            }
            if (PanDevMetrics.isProjectUninitialized(project)) {
                return;
            }
            VirtualFile virtualFile = PanDevMetrics.getCurrentVirtualFile(project);
            if (virtualFile == null) {
                return;
            }
            LineStatistics lineStatistics = PanDevMetrics.getLineStatistics(virtualFile);
            PanDevMetrics.appendHeartbeat(virtualFile, project, false, lineStatistics);
        }, 10L, TimeUnit.SECONDS);
    }

    private static void processHeartbeatQueue() {
        PanDevMetrics.checkIsConfigured();
        for (c c2 : kz.pandev.plugins.metrics.b.b.d()) {
            Heartbeat heartbeat;
            Heartbeat heartbeat2 = c2.b().poll();
            if (heartbeat2 == null) {
                return;
            }
            ArrayList<Heartbeat> arrayList = new ArrayList<Heartbeat>();
            while ((heartbeat = c2.b().poll()) != null) {
                arrayList.add(heartbeat);
            }
            PanDevMetrics.sendHeartbeat(c2, heartbeat2, arrayList);
        }
    }

    public static String heartBeatsToJSON(List<Heartbeat> list) {
        return GSON.toJson(list);
    }

    public static void addJsonObjectToFile(File file, List<Heartbeat> list) {
        if (file == null || list == null) {
            throw new IllegalArgumentException("File or heartbeat list is null");
        }
        try {
            List<Heartbeat> list2 = PanDevMetrics.readObjectsFromFile(file);
            list2.addAll(list);
            PanDevMetrics.writeObjectsToFile(list2, file);
        }
        catch (IOException iOException) {
            log.error("Failed to add JSON object to file: {}", (Object)file.getAbsoluteFile(), (Object)iOException);
        }
    }

    public static void sendHeartbeat(c c2, Heartbeat heartbeat, List<Heartbeat> list) {
        if (!list.isEmpty() && heartbeat != null) {
            list.add(0, heartbeat);
        } else {
            list.add(heartbeat);
        }
        if (c2.c(false).length() == 0L) {
            try {
                String string = kz.pandev.plugins.metrics.d.b.a(PanDevMetrics.heartBeatsToJSON(list));
                ApiClient.sendJsonStringToServer(c2, string, "/v5/handler");
            }
            catch (IOException | InterruptedException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException exception) {
                PanDevMetrics.addJsonObjectToFile(c2.c(false), list);
            }
        } else {
            try {
                PanDevMetrics.addHeartbeatsToQueueFileAndSendBatch(c2, list);
            }
            catch (IOException | InterruptedException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException exception) {
                PanDevMetrics.addJsonObjectToFile(c2.c(false), list);
            }
        }
    }

    public static void addHeartbeatsToQueueFileAndSendBatch(c c2, List<Heartbeat> list) throws IOException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException, InterruptedException {
        List<Heartbeat> list2 = PanDevMetrics.readObjectsFromFile(c2.c(false));
        list2.addAll(list);
        int n = Math.min(50, list2.size());
        List<Heartbeat> list3 = list2.subList(0, n);
        String string = kz.pandev.plugins.metrics.d.b.a(PanDevMetrics.heartBeatsToJSON(list3));
        try {
            ApiClient.sendJsonStringToServer(c2, string, "/v5/handler");
            c2.a(true);
        }
        catch (Exception exception) {
            c2.a(false);
            throw exception;
        }
        if (n < 50) {
            PanDevMetrics.clearFile(c2.c(false));
            c2.a(false);
        } else {
            list2.removeAll(list3);
            PanDevMetrics.writeObjectsToFile(list2, c2.c(false));
        }
    }

    public static List<Heartbeat> readObjectsFromFile(File file) throws IOException {
        ArrayList<Heartbeat> arrayList = new ArrayList<Heartbeat>();
        if (file.exists()) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                char[] cArray = new char[(int)file.length()];
                bufferedReader.read(cArray);
                String string = new String(cArray);
                String string2 = kz.pandev.plugins.metrics.d.b.b(string);
                Heartbeat[] heartbeatArray = (Heartbeat[])GSON.fromJson(string2, Heartbeat[].class);
                if (heartbeatArray != null) {
                    Collections.addAll(arrayList, heartbeatArray);
                }
            }
            catch (Exception exception) {
                throw new IOException("Error while decrypting data", exception);
            }
        }
        return arrayList;
    }

    public static void writeObjectsToFile(List<Heartbeat> list, File file) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            String string = GSON.toJson(list);
            String string2 = kz.pandev.plugins.metrics.d.b.a(string);
            bufferedWriter.write(string2);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static Module getCurrentModule(Project project, VirtualFile virtualFile) {
        Module[] moduleArray;
        if (virtualFile == null) {
            return null;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleArray = moduleManager.getModules()) {
            if (!ModuleRootManager.getInstance((Module)module).getFileIndex().isInContent(virtualFile)) continue;
            return module;
        }
        return null;
    }

    public static boolean enoughTimePassed(BigDecimal bigDecimal) {
        return lastTime.add(FREQUENCY).compareTo(bigDecimal) < 0;
    }

    public static boolean shouldLogFile(VirtualFile virtualFile) {
        if (virtualFile == null || virtualFile.getUrl().startsWith("mock://")) {
            return false;
        }
        String string = virtualFile.getPath();
        return !string.equals("atlassian-ide-plugin.xml") && !string.contains("/.idea/workspace.xml");
    }

    public static boolean isAppInactive() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() == null;
    }

    public static boolean isProjectUninitialized(Project project) {
        if (project == null) {
            return false;
        }
        return !project.isInitialized();
    }

    private static String getFileLanguage(VirtualFile virtualFile) {
        FileType fileType = virtualFile.getFileType();
        return fileType.getName();
    }

    @Nullable
    public static VirtualFile getVirtualFile(Document document) {
        if (document == null) {
            return null;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        return fileDocumentManager.getFile(document);
    }

    @Nullable
    public static VirtualFile getCurrentVirtualFile(Project project) {
        if (project == null) {
            return null;
        }
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        return PanDevMetrics.getVirtualFile(document);
    }

    public static Project getProject(Document document) {
        Editor[] editorArray = EditorFactory.getInstance().getEditors(document);
        if (editorArray.length > 0) {
            return editorArray[0].getProject();
        }
        return null;
    }

    @Nullable
    public static Project getCurrentProject() {
        Project project = null;
        try {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return project;
    }

    public static void openDashboardWebsite(String string) {
        BrowserUtil.browse((String)string);
    }

    public static void updateStatusBarText() {
        BigDecimal bigDecimal = PanDevMetrics.getCurrentTimestamp();
        if (todayTextTime.add(new BigDecimal(60)).compareTo(bigDecimal) > 0) {
            return;
        }
        todayTextTime = PanDevMetrics.getCurrentTimestamp();
        CompletableFuture.runAsync(PanDevMetrics::fetchTodayStats);
    }

    public static Map<String, ProjectStatus> fetchTodayStatusIcon(c c2, MultiValueMap multiValueMap) {
        if (c2.o()) {
            try {
                return ApiClient.isProjectsBelongsToCompany(c2, multiValueMap);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Failed to fetch today status icon", (Throwable)illegalArgumentException);
                return PanDevMetrics.buildStatusMap(multiValueMap, ProjectStatus.INACTIVE);
            }
            catch (IOException | InterruptedException | HttpException throwable) {
                log.error("Failed to fetch today status icon", throwable);
                return PanDevMetrics.buildStatusMap(multiValueMap, ProjectStatus.ISSUES);
            }
        }
        return PanDevMetrics.buildStatusMap(multiValueMap, ProjectStatus.ACTIVE);
    }

    public static void fetchTodayStats() {
        for (c c2 : kz.pandev.plugins.metrics.b.b.d()) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                log.debug("updating status bar for {}", (Object)project.getName());
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                statusBar.updateWidget(c2.d());
                statusBar.removeWidget("PanDevStatusbarWidget");
                a a2 = (a)statusBar.getWidget(c2.d());
                if (a2 != null) {
                    if (!c2.n()) {
                        statusBar.removeWidget(c2.d());
                        continue;
                    }
                    CompletableFuture.runAsync(() -> a2.a(c2));
                    log.info("called refresh in PanDevMetrics for settings {}", (Object)c2.d());
                    continue;
                }
                if (!c2.n()) continue;
                a a3 = new a(project, c2.d());
                statusBar.addWidget((StatusBarWidget)a3, (Disposable)project);
                CompletableFuture.runAsync(() -> a3.a(c2));
                log.info("added widget for server {}", (Object)c2.d());
            }
        }
    }

    public static LineStatistics getLineStatistics(@Nullable Document document, @Nullable Editor editor) {
        Object object;
        if (editor == null && document != null && (object = PanDevMetrics.getProject(document)) != null && object.isInitialized()) {
            editor = FileEditorManager.getInstance((Project)object).getSelectedTextEditor();
        }
        if (Objects.isNull(editor)) {
            return PanDevMetrics.getLineStatistics(document);
        }
        if (Objects.isNull(document)) {
            document = editor.getDocument();
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            LogicalPosition logicalPosition = caret.getLogicalPosition();
            LineStatistics lineStatistics = new LineStatistics();
            lineStatistics.setLineCount(document.getLineCount());
            lineStatistics.setLineNumber(logicalPosition.line + 1);
            lineStatistics.setCursorPosition(logicalPosition.column + 1);
            if (!lineStatistics.isAllFieldsNotNull()) continue;
            PanDevMetrics.saveLineStatistics(document, lineStatistics);
            return lineStatistics;
        }
        return PanDevMetrics.getLineStatistics(document);
    }

    public static LineStatistics getLineStatistics(@Nullable Document document) {
        if (document != null) {
            LineStatistics lineStatistics = new LineStatistics();
            lineStatistics.setLineCount(document.getLineCount());
            Caret caret = (Caret)CommonDataKeys.CARET.getData(DataManager.getInstance().getDataContext());
            LogicalPosition logicalPosition = caret.getLogicalPosition();
            lineStatistics.setLineNumber(logicalPosition.line + 1);
            lineStatistics.setCursorPosition(logicalPosition.column + 1);
            if (lineStatistics.isAllFieldsNotNull()) {
                PanDevMetrics.saveLineStatistics(document, lineStatistics);
                return lineStatistics;
            }
        }
        return PanDevMetrics.getLineStatistics(PanDevMetrics.getVirtualFile(document));
    }

    public static LineStatistics getLineStatistics(@Nullable VirtualFile virtualFile) {
        Caret caret = (Caret)CommonDataKeys.CARET.getData(DataManager.getInstance().getDataContext());
        if (caret == null) {
            return virtualFile == null ? new LineStatistics() : lineStatisticsCache.get(virtualFile.getPath());
        }
        LineStatistics lineStatistics = new LineStatistics();
        LogicalPosition logicalPosition = caret.getLogicalPosition();
        lineStatistics.setLineNumber(logicalPosition.line + 1);
        lineStatistics.setCursorPosition(logicalPosition.column + 1);
        Editor editor = caret.getEditor();
        Document document = editor.getDocument();
        lineStatistics.setLineCount(document.getLineCount());
        if (lineStatistics.isAllFieldsNotNull()) {
            PanDevMetrics.saveLineStatistics(virtualFile, lineStatistics);
            return lineStatistics;
        }
        return virtualFile == null ? new LineStatistics() : lineStatisticsCache.get(virtualFile.getPath());
    }

    public static void saveLineStatistics(Document document, LineStatistics lineStatistics) {
        VirtualFile virtualFile = PanDevMetrics.getVirtualFile(document);
        PanDevMetrics.saveLineStatistics(virtualFile, lineStatistics);
    }

    public static void saveLineStatistics(@Nullable VirtualFile virtualFile, LineStatistics lineStatistics) {
        if (virtualFile == null) {
            return;
        }
        if (!lineStatistics.isAllFieldsNotNull()) {
            return;
        }
        lineStatisticsCache.put(virtualFile.getPath(), lineStatistics);
    }

    public static void debugException(Exception exception) {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        String string = exception.getMessage() + "\n" + stringWriter;
        log.debug(string);
    }

    public static void warnException(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        String string = exception.getMessage() + "\n" + stringWriter;
        log.warn(string);
    }

    public static void clearFile(File file) throws IOException {
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write("");
        }
    }

    public static void setIsLoginPageCanceled(Boolean bl) {
        isLoginPageCanceled = bl;
    }

    public static void setIsSettingsWindowOpen(boolean bl) {
        isSettingsWindowOpen = bl;
    }

    private static Map<String, ProjectStatus> buildStatusMap(MultiValueMap multiValueMap, ProjectStatus projectStatus) {
        HashMap<String, ProjectStatus> hashMap = new HashMap<String, ProjectStatus>();
        for (Object e2 : multiValueMap.entrySet()) {
            Collection collection = (Collection)((Map.Entry)e2).getValue();
            for (String string : collection) {
                hashMap.put(string, projectStatus);
            }
        }
        return hashMap;
    }

    private static String getRelativePath(Project project, VirtualFile virtualFile) {
        String string = project.getBasePath();
        String string2 = virtualFile.getPath();
        if (string == null || string2 == null) {
            return null;
        }
        Path path = Paths.get(string, new String[0]);
        Path path2 = Paths.get(string2, new String[0]);
        Path path3 = path.relativize(path2);
        return path3.toString().replace("\\", "/");
    }

    static {
        lastFile = null;
        lastTime = new BigDecimal(0);
        IS_BUILDING = false;
        isLoginPageCanceled = false;
        isSettingsWindowOpen = false;
        scheduler = Executors.newScheduledThreadPool(1);
        GSON = new GsonBuilder().setPrettyPrinting().create();
        isVersionChecked = false;
        todayTextTime = new BigDecimal(0);
    }
}

