/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.clients;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.configs.c;
import kz.pandev.plugins.metrics.d.b;
import kz.pandev.plugins.metrics.d.d;
import kz.pandev.plugins.metrics.d.f;
import kz.pandev.plugins.metrics.d.g;
import kz.pandev.plugins.metrics.d.i;
import kz.pandev.plugins.metrics.d.j;
import kz.pandev.plugins.metrics.models.PluginVersionInfoDto;
import kz.pandev.plugins.metrics.models.ProjectOwnershipStatus;
import kz.pandev.plugins.metrics.models.ProjectOwnershipStatusResponseDto;
import kz.pandev.plugins.metrics.models.ServerSettingsDto;
import kz.pandev.plugins.metrics.models.SignInRequest;
import kz.pandev.plugins.metrics.models.SignInRequestV2;
import kz.pandev.plugins.metrics.models.UserQuickDateDto;
import kz.pandev.plugins.metrics.models.enums.ProjectStatus;
import kz.pandev.plugins.metrics.models.events.PanDevMetricsEvent;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.http.HttpException;
import org.jetbrains.annotations.NotNull;

public class ApiClient {
    static HttpClient httpClient = HttpClient.newHttpClient();
    private static final String APPLICATION_CONTENT_TYPE = "application/json";
    private static final String EXCEPTION_MESSAGE = "The server responded with an error code: ";

    private ApiClient() {
    }

    public static void sendEventsToServer(c c2, List<? extends PanDevMetricsEvent> list, String string) throws IOException, InterruptedException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(c2.g() + string)).header("Content-Type", APPLICATION_CONTENT_TYPE).header("Authorization", c2.m()).POST(HttpRequest.BodyPublishers.ofString(b.a(f.a(list)))).timeout(Duration.of(30L, ChronoUnit.SECONDS)).build();
        ApiClient.sendRequest(httpRequest);
    }

    public static void sendJsonStringToServer(c c2, String string, String string2) throws IOException, InterruptedException {
        ApiClient.sendJsonStringToServer(c2, string, string2, new HashMap<String, String>());
    }

    public static void sendJsonStringToServer(c c2, String string, String string2, Map<String, String> map) throws IOException, InterruptedException {
        String string3 = c2.g();
        String string4 = c2.m();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string3 + string2 + ApiClient.parseParams(map))).header("Content-Type", APPLICATION_CONTENT_TYPE).header("Authorization", string4).POST(HttpRequest.BodyPublishers.ofString(string)).timeout(Duration.of(30L, ChronoUnit.SECONDS)).build();
        ApiClient.sendRequest(httpRequest);
    }

    public static HttpResponse<String> getToken(String string, String string2, String string3, String string4) {
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string3 + "/v1/auth/sign-in")).header("Content-Type", APPLICATION_CONTENT_TYPE).POST(HttpRequest.BodyPublishers.ofString(ApiClient.getUserDataAsJson(string, string2, string4))).timeout(Duration.of(10L, ChronoUnit.SECONDS)).build();
        try {
            return httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException exception) {
            PanDevMetrics.log.error(exception.getMessage());
            return null;
        }
    }

    public static HttpResponse<String> getToken(String string, String string2, String string3, String string4, String string5) {
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string3 + "/v2/auth/sign-in")).header("Content-Type", APPLICATION_CONTENT_TYPE).POST(HttpRequest.BodyPublishers.ofString(ApiClient.getUserDataAsJson(string, string2, string4, string5))).timeout(Duration.of(10L, ChronoUnit.SECONDS)).build();
        try {
            return httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException exception) {
            PanDevMetrics.log.error(exception.getMessage());
            return null;
        }
    }

    static HttpResponse<String> sendRequest(HttpRequest httpRequest) throws IOException, InterruptedException {
        HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        if (httpResponse == null || httpResponse.statusCode() != 200) {
            PanDevMetrics.log.error("Request failed to url {}", (Object)httpRequest.uri());
            throw new IOException();
        }
        i.a(httpResponse);
        return httpResponse;
    }

    private static HttpResponse<String> sendGetRequest(String string, c c2) throws IOException, InterruptedException {
        String string2 = c2.m();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string)).header("Content-Type", APPLICATION_CONTENT_TYPE).header("Authorization", string2).GET().timeout(Duration.of(5L, ChronoUnit.SECONDS)).build();
        return ApiClient.sendRequest(httpRequest);
    }

    private static String getUserDataAsJson(String string, String string2, String string3) {
        SignInRequest signInRequest = new SignInRequest();
        signInRequest.setUsername(string);
        signInRequest.setPassword(string2);
        signInRequest.setUserTimeZone(string3);
        signInRequest.setSystemTimeZone(TimeZone.getDefault().getID());
        signInRequest.setIpAddress(d.a());
        signInRequest.setMacAddress(g.a());
        signInRequest.setCountry(Locale.getDefault().getDisplayCountry(Locale.ENGLISH));
        try {
            return new ObjectMapper().writeValueAsString((Object)signInRequest);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return "";
        }
    }

    private static String getUserDataAsJson(String string, String string2, String string3, String string4) {
        SignInRequestV2 signInRequestV2 = new SignInRequestV2();
        signInRequestV2.setUsername(string);
        signInRequestV2.setPassword(string2);
        signInRequestV2.setUserTimeZone(string3);
        signInRequestV2.setSystemTimeZone(TimeZone.getDefault().getID());
        signInRequestV2.setIpAddress(d.a());
        signInRequestV2.setMacAddress(g.a());
        signInRequestV2.setCountry(Locale.getDefault().getDisplayCountry(Locale.ENGLISH));
        signInRequestV2.setCompanyLogin(string4);
        try {
            return new ObjectMapper().writeValueAsString((Object)signInRequestV2);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return "";
        }
    }

    public static UserQuickDateDto fetchTodayUsersData(c c2) throws IOException, InterruptedException {
        String string = c2.g() + "/v1/user/today";
        HttpResponse<String> httpResponse = ApiClient.sendGetRequest(string, c2);
        ObjectMapper objectMapper = new ObjectMapper();
        return (UserQuickDateDto)objectMapper.readValue(httpResponse.body(), UserQuickDateDto.class);
    }

    public static Map<String, ProjectStatus> isProjectsBelongsToCompany(c c2, MultiValueMap multiValueMap) throws IOException, InterruptedException, HttpException {
        String string = String.join((CharSequence)",", multiValueMap.keySet());
        String string2 = c2.g() + "/is-project-belongs?projectNames=" + string;
        HttpResponse<String> httpResponse = ApiClient.sendGetRequest(string2, c2);
        if (httpResponse.statusCode() != 200) {
            throw new HttpException(EXCEPTION_MESSAGE + httpResponse.statusCode());
        }
        ObjectMapper objectMapper = new ObjectMapper();
        ProjectOwnershipStatusResponseDto projectOwnershipStatusResponseDto = (ProjectOwnershipStatusResponseDto)objectMapper.readValue(httpResponse.body(), ProjectOwnershipStatusResponseDto.class);
        if (projectOwnershipStatusResponseDto == null || projectOwnershipStatusResponseDto.getProjects().isEmpty()) {
            throw new HttpException("Response from server is null or empty");
        }
        HashMap<String, ProjectStatus> hashMap = new HashMap<String, ProjectStatus>();
        for (ProjectOwnershipStatus projectOwnershipStatus : projectOwnershipStatusResponseDto.getProjects()) {
            for (Object e2 : multiValueMap.entrySet()) {
                Collection collection = (Collection)((Map.Entry)e2).getValue();
                for (String string3 : collection) {
                    hashMap.put(string3, projectOwnershipStatus.isBelongs() ? ProjectStatus.ACTIVE : ProjectStatus.INACTIVE);
                }
            }
        }
        return hashMap;
    }

    public static ServerSettingsDto getServerSettings(String string, String string2) {
        String string3 = string + "/v1/server-settings";
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string3)).header("Content-Type", APPLICATION_CONTENT_TYPE).header("Authorization", "Bearer " + string2).GET().timeout(Duration.of(5L, ChronoUnit.SECONDS)).build();
        try {
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            ObjectMapper objectMapper = new ObjectMapper();
            return (ServerSettingsDto)objectMapper.readValue(httpResponse.body(), ServerSettingsDto.class);
        }
        catch (IOException | InterruptedException exception) {
            PanDevMetrics.log.error("Error while fetching user activity by projects", (Throwable)exception);
            return new ServerSettingsDto();
        }
    }

    private static String parseParams(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        return "?" + map.entrySet().stream().map(entry -> URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
    }

    public static PluginVersionInfoDto getLatestVersionOfPluginFromMetricsServer(String string) {
        try {
            PanDevMetrics.log.info("Sending request to URL: {}", (Object)string);
            if (Objects.isNull(string) || string.isBlank()) {
                throw new IllegalArgumentException("URL is null or blank");
            }
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string)).GET().build();
            HttpResponse<String> httpResponse = HttpClient.newHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (httpResponse.statusCode() != 200) {
                throw new IOException(EXCEPTION_MESSAGE + httpResponse.statusCode());
            }
            ObjectMapper objectMapper = new ObjectMapper();
            return (PluginVersionInfoDto)objectMapper.readValue(httpResponse.body(), PluginVersionInfoDto.class);
        }
        catch (InterruptedException interruptedException) {
            PanDevMetrics.log.error("Thread was interrupted while fetching plugin version : message - {}, class - {}", (Object)interruptedException.getMessage(), (Object)interruptedException.getClass().getName());
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            PanDevMetrics.log.error("Unexpected error while fetching plugin version : message - {}, class - {}", (Object)iOException.getMessage(), (Object)iOException.getClass().getName());
        }
        catch (Exception exception) {
            PanDevMetrics.log.error("Unexpected error : message - {}, class - {}", (Object)exception.getMessage(), (Object)exception.getClass().getName());
        }
        return null;
    }

    public static void getLatestPluginFromMetricsServer(final String string) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Downloading plugin", true){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                j.b(string).run(progressIndicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "kz/pandev/plugins/metrics/clients/ApiClient$1", "run"));
            }
        });
    }
}

