/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.storage;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.d.b;
import kz.pandev.plugins.metrics.d.f;
import kz.pandev.plugins.metrics.models.ExecutionEventDto;
import org.jetbrains.annotations.NotNull;

@Service
@State(name="PanDevMetricsExecutionEventsStorage", storages={@Storage(value="PanDevMetricsExecutionEventsStorage.xml")})
public final class PanDevMetricsExecutionEvetsStorage
implements PersistentStateComponent<a> {
    private a state = new a();

    public a getState() {
        return this.state;
    }

    public void loadState(@NotNull a a2) {
        if (a2 == null) {
            PanDevMetricsExecutionEvetsStorage.$$$reportNull$$$0(0);
        }
        this.state = a2;
    }

    public static PanDevMetricsExecutionEvetsStorage getInstance() {
        return (PanDevMetricsExecutionEvetsStorage)ApplicationManager.getApplication().getService(PanDevMetricsExecutionEvetsStorage.class);
    }

    public void addExecutionEventsToServerQueue(String string, List<ExecutionEventDto> list) {
        for (ExecutionEventDto executionEventDto : list) {
            this.addExecutionEventToServerQueue(string, executionEventDto);
        }
    }

    public void addExecutionEventToServerQueue(String string, ExecutionEventDto executionEventDto) {
        try {
            this.getOrCreateExecutionEventsQueue(string).add(b.a(f.a(executionEventDto)));
        }
        catch (Exception exception) {
            PanDevMetrics.log.error("Failed to add execution event to server {} queue: {}", (Object)string, (Object)exception.getMessage(), (Object)exception);
        }
    }

    public List<ExecutionEventDto> getExecutionEventsQueue(String string) {
        List<String> list = this.getEncryptedExecutionEventsQueue(string);
        return list.stream().map(string2 -> {
            try {
                return (ExecutionEventDto)f.a.fromJson(b.b(string2), ExecutionEventDto.class);
            }
            catch (Exception exception) {
                PanDevMetrics.log.warn("Failed to decrypt execution event for server: {}", (Object)string);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void addBatchExecutionEventsToHeaderQueue(String string, List<ExecutionEventDto> list) {
        List<String> list2 = this.getOrCreateExecutionEventsQueue(string);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (ExecutionEventDto executionEventDto : list) {
            try {
                arrayList.add(b.a(f.a(executionEventDto)));
            }
            catch (Exception exception) {
                PanDevMetrics.log.error("Failed to encrypt execution event for domain {}: {}", (Object)string, (Object)exception.getMessage());
            }
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size() + list2.size());
        arrayList2.addAll(arrayList);
        arrayList2.addAll(list2);
        this.state.a.put(string, arrayList2);
    }

    private Map<String, List<String>> getEncryptedExecutionEventsQueues() {
        return this.state.a;
    }

    private List<String> getEncryptedExecutionEventsQueue(String string) {
        return this.getEncryptedExecutionEventsQueues().getOrDefault(string, Collections.emptyList());
    }

    private List<String> getOrCreateExecutionEventsQueue(String string2) {
        return this.state.a.computeIfAbsent(string2, string -> new ArrayList());
    }

    public void removeExecutionEventsQueue(String string) {
        this.getEncryptedExecutionEventsQueues().remove(string);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "kz/pandev/plugins/metrics/storage/PanDevMetricsExecutionEvetsStorage", "loadState"));
    }

    public static class a {
        public Map<String, List<String>> a = new HashMap<String, List<String>>();
    }
}

