/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.AppTopics;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.KeyboardFocusManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import kz.pandev.plugins.metrics.clients.ApiClient;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.factory.ServerSettingsFactory;
import kz.pandev.plugins.metrics.listeners.BulkAwareDocumentListenerImpl;
import kz.pandev.plugins.metrics.listeners.CaretListenerImpl;
import kz.pandev.plugins.metrics.listeners.EditorMouseListenerImpl;
import kz.pandev.plugins.metrics.listeners.FileDocumentManagerListenerImpl;
import kz.pandev.plugins.metrics.listeners.VisibleAreaListenerImpl;
import kz.pandev.plugins.metrics.models.Heartbeat;
import kz.pandev.plugins.metrics.models.LineStatistics;
import kz.pandev.plugins.metrics.models.UserActivityByDateAndProjectDto;
import kz.pandev.plugins.metrics.ui_dialogs.LoginPage;
import kz.pandev.plugins.metrics.utils.EncryptionUtil;
import kz.pandev.plugins.metrics.utils.GitInfoProvider;
import kz.pandev.plugins.metrics.widgets.PanDevStatusbarWidget;
import org.apache.http.HttpException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PanDevMetrics
implements ApplicationComponent {
    public static final BigDecimal FREQUENCY = new BigDecimal(120);
    public static final String CATEGORY = "PanDevMetrics";
    public static final Logger log = LogManager.getLogger(PanDevMetrics.class);
    public static Map<String, LineStatistics> lineStatisticsCache = new HashMap<String, LineStatistics>();
    public static String version;
    public static String IDE_VERSION;
    public static MessageBusConnection connection;
    public static String lastFile;
    public static BigDecimal lastTime;
    public static Boolean isBuilding;
    public static Boolean isLoginPageCanceled;
    private static final ScheduledExecutorService scheduler;
    private static final Gson gson;
    private static ScheduledFuture<?> scheduledFixture;
    private static BigDecimal todayTextTime;

    public static Icon getLogoIcon() {
        String theme = JBColor.isBright() ? "light" : "dark";
        return IconLoader.getIcon((String)("images/icons/status-bar-icon-" + theme + "-theme.svg"), PanDevMetrics.class);
    }

    public void initComponent() {
        try {
            version = PluginManager.getPlugin((PluginId)PluginId.getId((String)"kz.pandev.intellij.plugin")).getVersion();
        }
        catch (Exception e) {
            version = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"kz.pandev.intellij.plugin")).getVersion();
        }
        String message = "Initializing PanDev Metrics plugin v%s".formatted(version);
        log.info(message);
        IDE_VERSION = ApplicationInfo.getInstance().getFullApplicationName();
        ServerSettingsFactory.initServers();
        PanDevMetrics.initStatusBar();
        this.initEventListeners();
        PanDevMetrics.initQueueProcessor();
    }

    public static void initStatusBar() {
        PanDevMetrics.updateStatusBarText();
    }

    private void initEventListeners() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Disposable disposable = Disposer.newDisposable((String)"PanDevMetricsListener");
            MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
            messageBusConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListenerImpl());
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new BulkAwareDocumentListenerImpl(), disposable);
            EditorFactory.getInstance().getEventMulticaster().addEditorMouseListener((EditorMouseListener)new EditorMouseListenerImpl(), disposable);
            EditorFactory.getInstance().getEventMulticaster().addVisibleAreaListener((VisibleAreaListener)new VisibleAreaListenerImpl(), disposable);
            EditorFactory.getInstance().getEventMulticaster().addCaretListener((CaretListener)new CaretListenerImpl(), disposable);
        });
    }

    private static void initQueueProcessor() {
        Runnable handler = PanDevMetrics::processHeartbeatQueue;
        long delay = 30L;
        scheduledFixture = scheduler.scheduleAtFixedRate(handler, delay, delay, TimeUnit.SECONDS);
    }

    public void disposeComponent() {
        try {
            connection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            scheduledFixture.cancel(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PanDevMetrics.processHeartbeatQueue();
    }

    public static void checkIsConfigured() {
        if (isLoginPageCanceled.booleanValue()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = PanDevMetrics.getCurrentProject();
            if (project == null) {
                return;
            }
            ServerSettings serverSettings = ServerSettingsFactory.getDefaultServerSettings();
            if (serverSettings == null || !serverSettings.isConfigured()) {
                Application app;
                if (!(isLoginPageCanceled.booleanValue() || !(app = ApplicationManager.getApplication()).isUnitTestMode() && app.isDispatchThread())) {
                    return;
                }
                try {
                    LoginPage loginPage = new LoginPage(project);
                    loginPage.promptForEmail();
                }
                catch (Exception e) {
                    PanDevMetrics.warnException(e);
                }
            }
        });
    }

    public static BigDecimal getCurrentTimestamp() {
        return new BigDecimal(String.valueOf((double)System.currentTimeMillis() / 1000.0)).setScale(4, RoundingMode.HALF_UP);
    }

    public static void appendHeartbeat(VirtualFile file, Project project, boolean isWrite, @Nullable LineStatistics lineStatistics) {
        String gitName;
        PanDevMetrics.updateStatusBarText();
        if (!PanDevMetrics.shouldLogFile(file)) {
            return;
        }
        BigDecimal time = PanDevMetrics.getCurrentTimestamp();
        if (!isWrite && file.getPath().equals(lastFile) && !PanDevMetrics.enoughTimePassed(time)) {
            return;
        }
        lastFile = file.getPath();
        lastTime = time;
        String moduleName = null;
        String moduleGitName = null;
        String moduleGitBranch = null;
        Module currentModule = PanDevMetrics.getCurrentModule(project, file);
        if (currentModule != null) {
            moduleName = currentModule.getName();
            moduleGitBranch = GitInfoProvider.getModuleGitBranch(currentModule);
            moduleGitName = GitInfoProvider.getModuleGitRepositoryName(currentModule);
        }
        String projectBasePath = project.getBasePath();
        String finalModuleName = moduleName != null ? moduleName : project.getName();
        String projectName = project.getName();
        String language = PanDevMetrics.getFileLanguage(file);
        String[] gitInfo = GitInfoProvider.getGitBranch(projectBasePath);
        String string = moduleGitName != null ? moduleGitName : (gitName = gitInfo.length > 0 ? gitInfo[0] : null);
        String gitBranch = moduleGitBranch != null ? moduleGitBranch : (gitInfo.length > 1 ? gitInfo[1] : null);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Heartbeat h = new Heartbeat();
            h.setTimestamp(time);
            h.setProject(projectName);
            h.setModule(finalModuleName);
            h.setLanguage(language);
            h.setGitBranch(gitBranch);
            h.setGitName(gitName);
            h.setFileName(file.getName());
            h.setIde(IDE_VERSION);
            h.setLineCount(lineStatistics.lineCount);
            h.setLineNumber(lineStatistics.lineNumber);
            h.setCursorPosition(lineStatistics.cursorPosition);
            for (ServerSettings serverSetting : ServerSettingsFactory.getAllServerSettings()) {
                serverSetting.getHeartbeatsQueue().add(h);
            }
            if (Boolean.TRUE.equals(isBuilding)) {
                PanDevMetrics.setBuildTimeout();
            }
        });
    }

    private static void setBuildTimeout() {
        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
            if (Boolean.FALSE.equals(isBuilding)) {
                return;
            }
            Project project = PanDevMetrics.getCurrentProject();
            if (project == null) {
                return;
            }
            if (!PanDevMetrics.isProjectInitialized(project)) {
                return;
            }
            VirtualFile file = PanDevMetrics.getCurrentVirtualFile(project);
            if (file == null) {
                return;
            }
            LineStatistics lineStatistics = PanDevMetrics.getLineStatistics(file);
            PanDevMetrics.appendHeartbeat(file, project, false, lineStatistics);
        }, 10L, TimeUnit.SECONDS);
    }

    private static void processHeartbeatQueue() {
        PanDevMetrics.checkIsConfigured();
        for (ServerSettings serverSetting : ServerSettingsFactory.getAllServerSettings()) {
            Heartbeat h;
            Heartbeat heartbeat = serverSetting.getHeartbeatsQueue().poll();
            if (heartbeat == null) {
                return;
            }
            ArrayList<Heartbeat> extraHeartbeats = new ArrayList<Heartbeat>();
            while ((h = serverSetting.getHeartbeatsQueue().poll()) != null) {
                extraHeartbeats.add(h);
            }
            PanDevMetrics.sendHeartbeat(serverSetting, heartbeat, extraHeartbeats);
        }
    }

    public static String heartBeatsToJSON(List<Heartbeat> extraHeartbeats) {
        return gson.toJson(extraHeartbeats);
    }

    public static void addJsonObjectToFile(File file, List<Heartbeat> heartbeats) {
        if (file == null || heartbeats == null) {
            throw new IllegalArgumentException("File or heartbeat list is null");
        }
        try {
            List<Heartbeat> existingObjects = PanDevMetrics.readObjectsFromFile(file);
            existingObjects.addAll(heartbeats);
            PanDevMetrics.writeObjectsToFile(existingObjects, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendHeartbeat(ServerSettings serverSettings, Heartbeat heartbeat, ArrayList<Heartbeat> extraHeartbeats) {
        if (!extraHeartbeats.isEmpty() && heartbeat != null) {
            extraHeartbeats.add(0, heartbeat);
        } else {
            extraHeartbeats.add(heartbeat);
        }
        if (serverSettings.getQueueFile(false).length() == 0L) {
            try {
                String encryptedJson = EncryptionUtil.encrypt(PanDevMetrics.heartBeatsToJSON(extraHeartbeats));
                ApiClient.sendJsonStringToServer(serverSettings, encryptedJson);
            }
            catch (Exception e) {
                PanDevMetrics.addJsonObjectToFile(serverSettings.getQueueFile(false), extraHeartbeats);
            }
        } else {
            try {
                PanDevMetrics.addHeartbeatsToQueueFileAndSendBatch(serverSettings, extraHeartbeats);
            }
            catch (Exception e) {
                PanDevMetrics.addJsonObjectToFile(serverSettings.getQueueFile(false), extraHeartbeats);
            }
        }
    }

    public static void addHeartbeatsToQueueFileAndSendBatch(ServerSettings serverSettings, List<Heartbeat> heartbeats) throws Exception {
        List<Heartbeat> allHeartbeats = PanDevMetrics.readObjectsFromFile(serverSettings.getQueueFile(false));
        allHeartbeats.addAll(heartbeats);
        int batchSize = Math.min(50, allHeartbeats.size());
        List<Heartbeat> heartbeatsBatch = allHeartbeats.subList(0, batchSize);
        String encryptedJson = EncryptionUtil.encrypt(PanDevMetrics.heartBeatsToJSON(heartbeatsBatch));
        ApiClient.sendJsonStringToServer(serverSettings, encryptedJson);
        if (batchSize < 50) {
            PanDevMetrics.clearFile(serverSettings.getQueueFile(false));
        } else {
            allHeartbeats.removeAll(heartbeatsBatch);
            PanDevMetrics.writeObjectsToFile(allHeartbeats, serverSettings.getQueueFile(false));
        }
    }

    public static List<Heartbeat> readObjectsFromFile(File file) throws IOException {
        ArrayList<Heartbeat> existingObjects = new ArrayList<Heartbeat>();
        if (file.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                char[] buffer = new char[(int)file.length()];
                reader.read(buffer);
                String encryptedJson = new String(buffer);
                String decryptedJson = EncryptionUtil.decrypt(encryptedJson);
                Heartbeat[] objectsArray = (Heartbeat[])gson.fromJson(decryptedJson, Heartbeat[].class);
                if (objectsArray != null) {
                    Collections.addAll(existingObjects, objectsArray);
                }
            }
            catch (Exception e) {
                throw new IOException("Error while decrypting data", e);
            }
        }
        return existingObjects;
    }

    public static void writeObjectsToFile(List<Heartbeat> heartbeats, File file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            String json = gson.toJson(heartbeats);
            String encryptedJson = EncryptionUtil.encrypt(json);
            writer.write(encryptedJson);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Module getCurrentModule(Project project, VirtualFile virtualFile) {
        Module[] modules;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : modules = moduleManager.getModules()) {
            if (!ModuleRootManager.getInstance((Module)module).getFileIndex().isInContent(virtualFile)) continue;
            return module;
        }
        return null;
    }

    public static boolean enoughTimePassed(BigDecimal currentTime) {
        return lastTime.add(FREQUENCY).compareTo(currentTime) < 0;
    }

    public static boolean shouldLogFile(VirtualFile file) {
        if (file == null || file.getUrl().startsWith("mock://")) {
            return false;
        }
        String filePath = file.getPath();
        return !filePath.equals("atlassian-ide-plugin.xml") && !filePath.contains("/.idea/workspace.xml");
    }

    public static boolean isAppActive() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() != null;
    }

    public static boolean isProjectInitialized(Project project) {
        if (project == null) {
            return true;
        }
        return project.isInitialized();
    }

    private static String getFileLanguage(VirtualFile file) {
        FileType type = file.getFileType();
        return type.getName();
    }

    @Nullable
    public static VirtualFile getVirtualFile(Document document) {
        if (document == null) {
            return null;
        }
        FileDocumentManager instance = FileDocumentManager.getInstance();
        return instance.getFile(document);
    }

    @Nullable
    public static VirtualFile getCurrentVirtualFile(Project project) {
        if (project == null) {
            return null;
        }
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        return PanDevMetrics.getVirtualFile(document);
    }

    public static Project getProject(Document document) {
        Editor[] editors = EditorFactory.getInstance().getEditors(document);
        if (editors.length > 0) {
            return editors[0].getProject();
        }
        return null;
    }

    @Nullable
    public static Project getCurrentProject() {
        Project project = null;
        try {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return project;
    }

    public static void openDashboardWebsite(String url) {
        BrowserUtil.browse((String)url);
    }

    public static void updateStatusBarText() {
        BigDecimal now = PanDevMetrics.getCurrentTimestamp();
        if (todayTextTime.add(new BigDecimal(60)).compareTo(now) > 0) {
            return;
        }
        todayTextTime = PanDevMetrics.getCurrentTimestamp();
        CompletableFuture.runAsync(PanDevMetrics::fetchTodayStats);
    }

    public static Map<String, PanDevStatusbarWidget.ModuleStatus.Status> fetchTodayStatusIcon(ServerSettings serverSettings, String ... moduleNames) {
        if (serverSettings.isGitEnabled()) {
            try {
                return ApiClient.isProjectsBelongsToCompany(serverSettings, moduleNames);
            }
            catch (IOException | InterruptedException | HttpException e) {
                log.error("Failed to fetch today status icon", e);
                HashMap<String, PanDevStatusbarWidget.ModuleStatus.Status> statusMap = new HashMap<String, PanDevStatusbarWidget.ModuleStatus.Status>();
                for (String name : moduleNames) {
                    statusMap.put(name, PanDevStatusbarWidget.ModuleStatus.Status.ISSUES);
                }
                return statusMap;
            }
        }
        HashMap<String, PanDevStatusbarWidget.ModuleStatus.Status> statusMap = new HashMap<String, PanDevStatusbarWidget.ModuleStatus.Status>();
        PanDevStatusbarWidget.ModuleStatus.Status status = PanDevStatusbarWidget.ModuleStatus.Status.ACTIVE;
        for (String name : moduleNames) {
            statusMap.put(name, status);
        }
        return statusMap;
    }

    public static void fetchTodayStats() {
        for (ServerSettings serverSettings : ServerSettingsFactory.getAllServerSettings()) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                log.debug("updating status bar for {}", (Object)project.getName());
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                statusBar.updateWidget(serverSettings.getDomain());
                statusBar.removeWidget("PanDevStatusbarWidget");
                PanDevStatusbarWidget widget = (PanDevStatusbarWidget)statusBar.getWidget(serverSettings.getDomain());
                if (widget != null) {
                    if (!serverSettings.isStatusBarEnabled()) {
                        statusBar.removeWidget(serverSettings.getDomain());
                        continue;
                    }
                    CompletableFuture.runAsync(() -> widget.refresh(serverSettings));
                    log.info("called refresh in PanDevMetrics for settings {}", (Object)serverSettings.getDomain());
                    continue;
                }
                if (!serverSettings.isStatusBarEnabled()) continue;
                PanDevStatusbarWidget newWidget = new PanDevStatusbarWidget(project, serverSettings.getDomain());
                statusBar.addWidget((StatusBarWidget)newWidget);
                CompletableFuture.runAsync(() -> newWidget.refresh(serverSettings));
                log.info("added widget for server {}", (Object)serverSettings.getDomain());
            }
        }
    }

    public static LineStatistics getLineStatistics(@Nullable Document document, @Nullable Editor editor) {
        Project project;
        if (editor == null && document != null && (project = PanDevMetrics.getProject(document)) != null && project.isInitialized()) {
            editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        }
        if (editor != null) {
            if (document == null) {
                document = editor.getDocument();
            }
            for (Caret caret : editor.getCaretModel().getAllCarets()) {
                LineStatistics lineStatistics = new LineStatistics();
                if (document != null) {
                    lineStatistics.lineCount = document.getLineCount();
                }
                LogicalPosition position = caret.getLogicalPosition();
                lineStatistics.lineNumber = position.line + 1;
                lineStatistics.cursorPosition = position.column + 1;
                if (!lineStatistics.isAllFieldsNotNull()) continue;
                PanDevMetrics.saveLineStatistics(document, lineStatistics);
                return lineStatistics;
            }
        }
        return PanDevMetrics.getLineStatistics(document);
    }

    public static LineStatistics getLineStatistics(@Nullable Document document) {
        if (document != null) {
            LineStatistics lineStatistics = new LineStatistics();
            lineStatistics.lineCount = document.getLineCount();
            Caret caret = (Caret)CommonDataKeys.CARET.getData(DataManager.getInstance().getDataContext());
            LogicalPosition position = caret.getLogicalPosition();
            lineStatistics.lineNumber = position.line + 1;
            lineStatistics.cursorPosition = position.column + 1;
            if (lineStatistics.isAllFieldsNotNull()) {
                PanDevMetrics.saveLineStatistics(document, lineStatistics);
                return lineStatistics;
            }
        }
        return PanDevMetrics.getLineStatistics(PanDevMetrics.getVirtualFile(document));
    }

    public static LineStatistics getLineStatistics(@Nullable VirtualFile file) {
        Document document;
        Caret caret = (Caret)CommonDataKeys.CARET.getData(DataManager.getInstance().getDataContext());
        LogicalPosition position = caret.getLogicalPosition();
        LineStatistics lineStatistics = new LineStatistics();
        Editor editor = caret.getEditor();
        if (editor != null && (document = editor.getDocument()) != null) {
            lineStatistics.lineCount = document.getLineCount();
        }
        lineStatistics.lineNumber = position.line + 1;
        lineStatistics.cursorPosition = position.column + 1;
        if (lineStatistics.isAllFieldsNotNull()) {
            PanDevMetrics.saveLineStatistics(file, lineStatistics);
            return lineStatistics;
        }
        if (file == null) {
            return new LineStatistics();
        }
        return lineStatisticsCache.get(file.getPath());
    }

    public static void saveLineStatistics(Document document, LineStatistics lineStatistics) {
        VirtualFile file = PanDevMetrics.getVirtualFile(document);
        PanDevMetrics.saveLineStatistics(file, lineStatistics);
    }

    public static void saveLineStatistics(@Nullable VirtualFile file, LineStatistics lineStatistics) {
        if (file == null) {
            return;
        }
        if (!lineStatistics.isAllFieldsNotNull()) {
            return;
        }
        lineStatisticsCache.put(file.getPath(), lineStatistics);
    }

    public static UserActivityByDateAndProjectDto fetchTodayModulesActivity(ServerSettings serverSettings, String ... moduleNames) {
        try {
            return ApiClient.fetchUserActivityByProjects(serverSettings, LocalDate.now(ZoneId.of(serverSettings.getServerZoneId())), moduleNames);
        }
        catch (IOException | InterruptedException e) {
            return null;
        }
    }

    public static void debugException(Exception e) {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String str = e.getMessage() + "\n" + String.valueOf(sw);
        log.debug(str);
    }

    public static void warnException(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String str = e.getMessage() + "\n" + String.valueOf(sw);
        log.warn(str);
    }

    public static void clearFile(File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write("");
        }
    }

    @NotNull
    public String getComponentName() {
        return CATEGORY;
    }

    static {
        lastFile = null;
        lastTime = new BigDecimal(0);
        isBuilding = false;
        isLoginPageCanceled = false;
        scheduler = Executors.newScheduledThreadPool(1);
        gson = new GsonBuilder().setPrettyPrinting().create();
        todayTextTime = new BigDecimal(0);
    }
}

