/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.clients;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.application.ApplicationManager;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.models.JwtAuthenticationResponseDto;
import kz.pandev.plugins.metrics.models.ProjectOwnershipStatus;
import kz.pandev.plugins.metrics.models.ProjectOwnershipStatusResponseDto;
import kz.pandev.plugins.metrics.models.ServerSettingsDto;
import kz.pandev.plugins.metrics.models.SignInRequest;
import kz.pandev.plugins.metrics.models.UserActivityByDateAndProjectDto;
import kz.pandev.plugins.metrics.models.UserQuickDateDto;
import kz.pandev.plugins.metrics.ui_dialogs.Settings;
import kz.pandev.plugins.metrics.utils.IPAddressUtil;
import kz.pandev.plugins.metrics.utils.MACAddressUtil;
import kz.pandev.plugins.metrics.widgets.PanDevStatusbarWidget;
import org.apache.http.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiClient {
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    private static final String APPLICATION_CONTENT_TYPE = "application/json";
    private static final String AUTH_TYPE_BEARER = "Bearer";
    private static final String EXCEPTION_MESSAGE = "The server responded with an error code: ";
    private static final Logger log = LoggerFactory.getLogger(ApiClient.class);

    private ApiClient() {
    }

    public static void sendJsonStringToServer(ServerSettings serverSettings, String json) throws Exception {
        String url = serverSettings.getSettings("settings", "url");
        String email = serverSettings.getSettings("settings", "email");
        String token = serverSettings.getSettings("settings", "token");
        String headerValue = "Bearer " + token;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url + "/v2/handler?email=" + email)).header("Content-Type", APPLICATION_CONTENT_TYPE).header("Authorization", headerValue).POST(HttpRequest.BodyPublishers.ofString(json)).timeout(Duration.of(30L, ChronoUnit.SECONDS)).build();
        ApiClient.sendRequest(request, serverSettings);
    }

    public static HttpResponse<String> getToken(String email, String password, String url, String timezone) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url + "/auth/sign-in")).header("Content-Type", APPLICATION_CONTENT_TYPE).POST(HttpRequest.BodyPublishers.ofString(ApiClient.getUserDataAsJson(email, password, timezone))).timeout(Duration.of(10L, ChronoUnit.SECONDS)).build();
        try {
            return HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            return null;
        }
    }

    public static void refreshToken(ServerSettings serverSettings) {
        try {
            String url = serverSettings.getUrl();
            ObjectMapper objectMapper = new ObjectMapper();
            String headerValue = serverSettings.getRefreshAuthentificationHeader();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url + "/auth/refresh-token")).header("Authorization", headerValue).PUT(HttpRequest.BodyPublishers.noBody()).timeout(Duration.of(10L, ChronoUnit.SECONDS)).build();
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response != null && response.statusCode() == 403) {
                if (!serverSettings.isShowing()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        Settings popup = new Settings(PanDevMetrics.getCurrentProject(), serverSettings);
                        popup.show();
                        serverSettings.setIsShowing(true);
                    });
                }
                throw new IOException();
            }
            if (response != null && response.statusCode() == 200) {
                JwtAuthenticationResponseDto responseDto = (JwtAuthenticationResponseDto)objectMapper.readValue(response.body(), JwtAuthenticationResponseDto.class);
                serverSettings.saveSettings("settings", Map.of("token", responseDto.getToken(), "refresh_token", responseDto.getRefreshToken()));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static HttpResponse<String> sendGetRequest(String url, ServerSettings serverSettings) throws IOException, InterruptedException {
        String authenticationHeader = serverSettings.getAuthenticationHeader();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", APPLICATION_CONTENT_TYPE).header("Authorization", authenticationHeader).GET().timeout(Duration.of(5L, ChronoUnit.SECONDS)).build();
        return ApiClient.sendRequest(request, serverSettings);
    }

    private static HttpResponse<String> sendRequest(HttpRequest request, ServerSettings serverSettings) throws IOException, InterruptedException {
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response != null && response.statusCode() == 403) {
            ApiClient.refreshToken(serverSettings);
            log.error("Refreshing token");
            throw new IOException();
        }
        if (response == null || response.statusCode() != 200) {
            log.error("Request failed to url " + String.valueOf(request.uri()));
            throw new IOException();
        }
        return response;
    }

    private static String getUserDataAsJson(String email, String password, String timezone) {
        String jsonString;
        SignInRequest signInRequest = new SignInRequest();
        signInRequest.setUsername(email);
        signInRequest.setPassword(password);
        signInRequest.setUserTimeZone(timezone);
        signInRequest.setSystemTimeZone(TimeZone.getDefault().getID());
        signInRequest.setIpAddress(IPAddressUtil.getPublicIPAddress());
        signInRequest.setMacAddress(MACAddressUtil.getMacAddress());
        String country = Locale.getDefault().getDisplayCountry(Locale.ENGLISH) == null ? "Country unknown" : Locale.getDefault().getDisplayCountry(Locale.ENGLISH);
        signInRequest.setCountry(country);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            jsonString = objectMapper.writeValueAsString((Object)signInRequest);
        }
        catch (JsonProcessingException e) {
            return "";
        }
        return jsonString;
    }

    public static UserQuickDateDto fetchUserBetweenDates(LocalDate startDate, LocalDate endDate, ServerSettings serverSettings) throws IOException, InterruptedException {
        String baseUrl = serverSettings.getUrl();
        String email = serverSettings.getSettings("settings", "email");
        String url = baseUrl + "/user/between-dates?email=" + email + "&startDate=" + String.valueOf(startDate) + "&endDate=" + String.valueOf(endDate);
        try {
            HttpResponse<String> response = ApiClient.sendGetRequest(url, serverSettings);
            if (response.statusCode() != 200) {
                throw new IOException(EXCEPTION_MESSAGE + response.statusCode());
            }
            ObjectMapper mapper = new ObjectMapper();
            return (UserQuickDateDto)mapper.readValue(response.body(), UserQuickDateDto.class);
        }
        catch (IOException | InterruptedException e) {
            PanDevMetrics.log.error("Failed to fetch user between dates: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public static UserActivityByDateAndProjectDto fetchUserActivityByProjects(ServerSettings serverSettings, LocalDate date, String ... projectNames) throws IOException, InterruptedException {
        String baseUrl = serverSettings.getUrl();
        String email = serverSettings.getSettings("settings", "email");
        String joinedProjectNames = String.join((CharSequence)",", projectNames);
        String url = baseUrl + "/user/by-projects/by-date?email=" + email + "&date=" + String.valueOf(date) + "&projectNames=" + joinedProjectNames;
        try {
            HttpResponse<String> response = ApiClient.sendGetRequest(url, serverSettings);
            if (response.statusCode() != 200) {
                throw new IOException(EXCEPTION_MESSAGE + response.statusCode());
            }
            ObjectMapper mapper = new ObjectMapper();
            return (UserActivityByDateAndProjectDto)mapper.readValue(response.body(), UserActivityByDateAndProjectDto.class);
        }
        catch (IOException | InterruptedException e) {
            PanDevMetrics.log.error("Error while fetching user activity by projects from host:" + serverSettings.getUrl(), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, PanDevStatusbarWidget.ModuleStatus.Status> isProjectsBelongsToCompany(ServerSettings serverSettings, String ... projectGitNames) throws IOException, InterruptedException, HttpException {
        String joinedProjectNames = String.join((CharSequence)",", projectGitNames);
        String baseUrl = serverSettings.getUrl();
        String url = baseUrl + "/is-project-belongs?projectNames=" + joinedProjectNames;
        HttpResponse<String> projectBelongsResponse = ApiClient.sendGetRequest(url, serverSettings);
        log.info("Handled response: {}", (Object)projectBelongsResponse.body());
        if (projectBelongsResponse.statusCode() != 200) {
            throw new HttpException(EXCEPTION_MESSAGE + projectBelongsResponse.statusCode());
        }
        ObjectMapper objectMapper = new ObjectMapper();
        ProjectOwnershipStatusResponseDto ownershipStatusResponseDto = (ProjectOwnershipStatusResponseDto)objectMapper.readValue(projectBelongsResponse.body(), ProjectOwnershipStatusResponseDto.class);
        log.info("Correct response from API endpoint is-project-belongs");
        if (ownershipStatusResponseDto != null && !ownershipStatusResponseDto.getProjects().isEmpty()) {
            HashMap<String, PanDevStatusbarWidget.ModuleStatus.Status> projectsBelongsToCompanyMap = new HashMap<String, PanDevStatusbarWidget.ModuleStatus.Status>();
            for (ProjectOwnershipStatus ownershipStatus : ownershipStatusResponseDto.getProjects()) {
                log.info(ownershipStatus.getProjectName() + " belongs?: " + ownershipStatus.isBelongs());
                projectsBelongsToCompanyMap.put(ownershipStatus.getProjectName(), ownershipStatus.isBelongs() ? PanDevStatusbarWidget.ModuleStatus.Status.ACTIVE : PanDevStatusbarWidget.ModuleStatus.Status.INACTIVE);
            }
            return projectsBelongsToCompanyMap;
        }
        throw new HttpException("response from server null");
    }

    public static ServerSettingsDto getServerSettings(String baseUrl) {
        String url = baseUrl + "/server-settings";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().timeout(Duration.of(5L, ChronoUnit.SECONDS)).build();
        try {
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            ObjectMapper mapper = new ObjectMapper();
            return (ServerSettingsDto)mapper.readValue(response.body(), ServerSettingsDto.class);
        }
        catch (IOException | InterruptedException e) {
            PanDevMetrics.log.error("Error while fetching user activity by projects", (Throwable)e);
            return new ServerSettingsDto();
        }
    }
}

