/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.configs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.configs.AuthenticationType;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.models.Heartbeat;
import kz.pandev.plugins.metrics.utils.SettingsFileReadWriterUtil;

public class LoginPasswordSettings
implements ServerSettings {
    public static final String EMAIL_KEY = "email";
    public static final String TOKEN_KEY = "token";
    public static final String REFRESH_TOKEN_KEY = "refresh_token";
    public static final String URL_KEY = "url";
    public static final String TIMEZONE_KEY = "timezone";
    public static final String SERVER_ZONE_ID_KEY = "server_zone_id";
    public static final String VISUALIZATION_URL_KEY = "visualization_url";
    private String cachedHomeFolder = null;
    private String fileName;
    private File settingsFile;
    private String internalFileName;
    private File queueFile;
    private String queueFileName;
    private Boolean debug = false;
    private Boolean statusBarEnabled = false;
    private Boolean gitEnabled;
    private final String domain;
    private String email;
    private String url;
    private String token;
    private String refreshToken;
    private String timezone;
    private Boolean isShowing = false;
    private String serverZoneId;
    private String visualizationUrl;
    public final ConcurrentLinkedQueue<Heartbeat> heartbeatsQueue = new ConcurrentLinkedQueue();

    public LoginPasswordSettings(String url, String email, String token, String refreshToken, String timezone, String serverZoneId, String visualizationUrl, boolean isStatusBarEnabled, boolean isGitEnabled) {
        this.url = url;
        this.email = email;
        this.token = token;
        this.refreshToken = refreshToken;
        this.timezone = timezone;
        this.domain = ServerSettings.getDomainInUrl(url);
        this.fileName = this.domain + "_pandev_metrics.cfg";
        this.internalFileName = this.domain + "_pandev_metrics_internal.cfg";
        this.queueFileName = this.domain + "_queue.json";
        this.statusBarEnabled = isStatusBarEnabled;
        this.gitEnabled = isGitEnabled;
        this.serverZoneId = serverZoneId;
        this.visualizationUrl = visualizationUrl;
        this.saveSettings("settings", Map.of(URL_KEY, url, EMAIL_KEY, email, TOKEN_KEY, token, REFRESH_TOKEN_KEY, refreshToken, TIMEZONE_KEY, timezone, SERVER_ZONE_ID_KEY, serverZoneId, VISUALIZATION_URL_KEY, visualizationUrl, "status_bar_enabled", isStatusBarEnabled ? "true" : "false", "debug", Boolean.TRUE.equals(this.debug) ? "true" : "false", "git", Boolean.TRUE.equals(this.gitEnabled) ? "true" : "false"));
        this.getQueueFile(false);
    }

    public LoginPasswordSettings(String domain) {
        this.domain = domain;
        this.fileName = this.domain + "_pandev_metrics.cfg";
        this.internalFileName = this.domain + "_pandev_metrics_internal.cfg";
        this.queueFileName = this.domain + "_queue.json";
        this.url = this.getSettings("settings", URL_KEY);
        this.email = this.getSettings("settings", EMAIL_KEY);
        this.token = this.getSettings("settings", TOKEN_KEY);
        this.refreshToken = this.getSettings("settings", REFRESH_TOKEN_KEY);
        this.timezone = this.getSettings("settings", TIMEZONE_KEY);
        this.serverZoneId = this.getSettings("settings", SERVER_ZONE_ID_KEY);
        this.visualizationUrl = this.getSettings("settings", VISUALIZATION_URL_KEY);
        this.statusBarEnabled = Objects.equals(this.getSettings("settings", "status_bar_enabled"), "true");
        this.debug = Objects.equals(this.getSettings("settings", "debug"), "true");
        this.gitEnabled = Objects.equals(this.getSettings("settings", "git"), "true");
    }

    @Override
    public void saveSettings(String section, Map<String, String> settings) {
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            SettingsFileReadWriterUtil.write(this.getConfigFile(false), section, key, value);
            switch (key) {
                case "email": {
                    this.email = value;
                    break;
                }
                case "token": {
                    this.token = value;
                    break;
                }
                case "refresh_token": {
                    this.refreshToken = value;
                    break;
                }
                case "url": {
                    this.url = value;
                    break;
                }
                case "timezone": {
                    this.timezone = value;
                    break;
                }
                case "server_zone_id": {
                    this.serverZoneId = value;
                    break;
                }
                case "visualization_url": {
                    this.visualizationUrl = value;
                    break;
                }
                case "status_bar_enabled": {
                    this.statusBarEnabled = Boolean.parseBoolean(value);
                    break;
                }
                case "debug": {
                    this.debug = Boolean.parseBoolean(value);
                    break;
                }
                case "git": {
                    this.gitEnabled = Boolean.parseBoolean(value);
                }
            }
        }
    }

    @Override
    public String getSettings(String section, String key) {
        String value = switch (key) {
            case EMAIL_KEY -> this.email;
            case TOKEN_KEY -> this.token;
            case REFRESH_TOKEN_KEY -> this.refreshToken;
            case URL_KEY -> this.url;
            case TIMEZONE_KEY -> this.timezone;
            case SERVER_ZONE_ID_KEY -> this.serverZoneId;
            case VISUALIZATION_URL_KEY -> this.visualizationUrl;
            default -> null;
        };
        return value != null ? value : SettingsFileReadWriterUtil.read(this.getConfigFile(false), section, key);
    }

    @Override
    public ConcurrentLinkedQueue<Heartbeat> getHeartbeatsQueue() {
        return this.heartbeatsQueue;
    }

    @Override
    public File getConfigFile(boolean internal) {
        if (!internal && this.settingsFile != null) {
            return this.settingsFile;
        }
        if (this.cachedHomeFolder == null) {
            File folder;
            if (System.getenv("PANDEV_METRICS_HOME") != null && !System.getenv("PANDEV_METRICS_HOME").trim().isEmpty() && (folder = new File(System.getenv("PANDEV_METRICS_HOME"))).exists()) {
                this.cachedHomeFolder = folder.getAbsolutePath();
                PanDevMetrics.log.debug("Using $PANDEV_METRICS_HOME for config folder: {}", (Object)this.cachedHomeFolder);
                if (internal) {
                    return new File(new File(this.cachedHomeFolder, ".pandev_metrics"), this.internalFileName);
                }
                this.settingsFile = new File(this.cachedHomeFolder, this.fileName);
                return this.settingsFile;
            }
            this.cachedHomeFolder = new File(System.getProperty("user.home")).getAbsolutePath();
            PanDevMetrics.log.debug("Using $HOME for config folder: {}", (Object)this.cachedHomeFolder);
        }
        if (internal) {
            return new File(new File(this.cachedHomeFolder, ".pandev_metrics"), this.internalFileName);
        }
        this.settingsFile = new File(this.cachedHomeFolder, this.fileName);
        return this.settingsFile;
    }

    @Override
    public File getQueueFile(boolean internal) {
        if (!internal && this.queueFile != null) {
            return this.queueFile;
        }
        String currentDir = System.getProperty("user.home");
        String filePath = currentDir + File.separator + this.queueFileName;
        this.queueFile = new File(filePath);
        if (!this.queueFile.exists()) {
            try {
                Files.createFile(Path.of(filePath, new String[0]), new FileAttribute[0]);
                this.queueFile = new File(filePath);
            }
            catch (IOException e) {
                PanDevMetrics.log.error(e.getMessage());
            }
        }
        return this.queueFile;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public AuthenticationType getAuthenticationType() {
        return AuthenticationType.LOGIN_PASSWORD;
    }

    @Override
    public boolean isConfigured() {
        return Stream.of(URL_KEY, EMAIL_KEY, TOKEN_KEY, REFRESH_TOKEN_KEY).map(key -> this.getSettings("settings", (String)key)).noneMatch(String::isEmpty);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getServerZoneId() {
        return this.serverZoneId;
    }

    @Override
    public String getVisualizationUrl() {
        return this.visualizationUrl;
    }

    @Override
    public String getAuthenticationHeader() {
        return "Bearer " + this.token;
    }

    @Override
    public boolean isStatusBarEnabled() {
        return this.statusBarEnabled;
    }

    @Override
    public boolean isGitEnabled() {
        return this.gitEnabled;
    }

    @Override
    public boolean isShowing() {
        return this.isShowing;
    }

    @Override
    public void setIsShowing(boolean isShowing) {
        this.isShowing = isShowing;
    }

    @Override
    public String getRefreshAuthentificationHeader() {
        return "Bearer " + this.refreshToken;
    }
}

