/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.listeners;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.models.LineStatistics;

public class CaretListenerImpl
implements CaretListener {
    public void caretPositionChanged(CaretEvent event) {
        try {
            if (!PanDevMetrics.isAppActive()) {
                return;
            }
            final Editor editor = event.getEditor();
            final Document document = editor.getDocument();
            final VirtualFile file = PanDevMetrics.getVirtualFile(document);
            if (file == null) {
                return;
            }
            final Project project = editor.getProject();
            if (!PanDevMetrics.isProjectInitialized(project)) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    LineStatistics lineStatistics = PanDevMetrics.getLineStatistics(document, editor);
                    PanDevMetrics.appendHeartbeat(file, project, false, lineStatistics);
                }
            });
        }
        catch (Exception e) {
            PanDevMetrics.debugException(e);
        }
    }
}

