/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.listeners;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Rectangle;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.models.LineStatistics;
import org.jetbrains.annotations.NotNull;

public class VisibleAreaListenerImpl
implements VisibleAreaListener {
    public void visibleAreaChanged(@NotNull VisibleAreaEvent visibleAreaEvent) {
        if (visibleAreaEvent == null) {
            VisibleAreaListenerImpl.$$$reportNull$$$0(0);
        }
        try {
            if (!this.didChange(visibleAreaEvent)) {
                return;
            }
            if (!PanDevMetrics.isAppActive()) {
                return;
            }
            Document document = visibleAreaEvent.getEditor().getDocument();
            VirtualFile file = PanDevMetrics.getVirtualFile(document);
            if (file == null) {
                return;
            }
            Project project = visibleAreaEvent.getEditor().getProject();
            if (!PanDevMetrics.isProjectInitialized(project)) {
                return;
            }
            Editor editor = visibleAreaEvent.getEditor();
            LineStatistics lineStatistics = PanDevMetrics.getLineStatistics(document, editor);
            PanDevMetrics.appendHeartbeat(file, project, false, lineStatistics);
        }
        catch (Exception e) {
            PanDevMetrics.debugException(e);
        }
    }

    private boolean didChange(VisibleAreaEvent visibleAreaEvent) {
        Rectangle oldRect = visibleAreaEvent.getOldRectangle();
        if (oldRect == null) {
            return true;
        }
        Rectangle newRect = visibleAreaEvent.getNewRectangle();
        if (newRect == null) {
            return false;
        }
        return newRect.x != oldRect.x || newRect.y != oldRect.y;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleAreaEvent", "kz/pandev/plugins/metrics/listeners/VisibleAreaListenerImpl", "visibleAreaChanged"));
    }
}

