/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.ui_dialogs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kz.pandev.plugins.metrics.clients.ApiClient;
import kz.pandev.plugins.metrics.models.JwtAuthenticationResponseDto;
import kz.pandev.plugins.metrics.models.ServerSettingsDto;
import kz.pandev.plugins.metrics.ui_dialogs.InformationDialog;
import kz.pandev.plugins.metrics.utils.EmailValidation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractSettingsView
extends DialogWrapper {
    protected final JPanel mainPanel = new JPanel(new BorderLayout());
    protected final JPanel titlePanel;
    protected final JPanel userInfoFormPanel;
    protected JLabel urlLabel;
    protected JTextField urlInput;
    protected JLabel emailLabel;
    protected JTextField emailInput;
    protected JLabel passwordLabel;
    protected JPasswordField passwordInput;
    protected JLabel timeZoneLabel;
    protected JComboBox<String> timeZoneComboBox;
    protected String token;
    protected String refreshToken;
    protected String timezone;
    protected Boolean isGitEnabled;
    protected String serverZoneId;
    protected String visualizationUrl;
    public static final String SETTINGS_FILE = "settings";
    public static final String FALSE_VALUE = "false";
    public static final String TRUE_VALUE = "true";

    protected AbstractSettingsView(@Nullable Project project) {
        super(project, true);
        this.mainPanel.setMaximumSize(new Dimension(700, 400));
        this.titlePanel = this.getTitlePanel();
        this.userInfoFormPanel = this.getUserInfoFormPenal(this.getDocumentListener());
        this.mainPanel.add((Component)this.titlePanel, "North");
        this.mainPanel.add((Component)this.userInfoFormPanel, "Center");
    }

    private JPanel getUserInfoFormPenal(DocumentListener documentListener) {
        JPanel userInfoOuterPanel = new JPanel(new GridLayout(0, 1));
        userInfoOuterPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)150));
        this.urlLabel = new JLabel("Server URL");
        this.urlInput = new JTextField();
        this.urlLabel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.urlInput.getDocument().addDocumentListener(documentListener);
        userInfoOuterPanel.add(this.urlLabel);
        userInfoOuterPanel.add(this.urlInput);
        this.emailLabel = new JLabel("Email");
        this.emailInput = new JTextField();
        this.emailInput.getDocument().addDocumentListener(documentListener);
        this.emailLabel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        userInfoOuterPanel.add(this.emailLabel);
        userInfoOuterPanel.add(this.emailInput);
        this.passwordLabel = new JLabel("Password");
        this.passwordInput = new JPasswordField();
        this.passwordInput.getDocument().addDocumentListener(documentListener);
        this.passwordLabel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        userInfoOuterPanel.add(this.passwordLabel);
        userInfoOuterPanel.add(this.passwordInput);
        this.timeZoneLabel = new JLabel("Timezone");
        this.timeZoneLabel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.timeZoneComboBox = new JComboBox<String>(TimeZone.getAvailableIDs());
        this.timeZoneComboBox.setSelectedItem(TimeZone.getDefault().getID());
        userInfoOuterPanel.add(this.timeZoneLabel);
        userInfoOuterPanel.add(this.timeZoneComboBox);
        return userInfoOuterPanel;
    }

    protected JPanel getTitlePanel() {
        JPanel panel = new JPanel();
        JLabel imageLabel = null;
        try {
            InputStream inputStream = AbstractSettingsView.getLogoImage();
            BufferedImage img = ImageIO.read(inputStream);
            Image dimg = img.getScaledInstance(28, 36, 4);
            ImageIcon imageIcon = new ImageIcon(dimg);
            imageLabel = new JLabel(imageIcon);
        }
        catch (IOException e) {
            imageLabel = new JLabel(e.getMessage());
        }
        JLabel titleLabel = new JLabel("PanDev Metrics");
        titleLabel.setFont(new Font("Arial", 1, 16));
        imageLabel.setBorder((Border)JBUI.Borders.emptyRight((int)5));
        panel.add(imageLabel);
        panel.add(titleLabel);
        panel.setBorder((Border)JBUI.Borders.empty((int)10, (int)0));
        return panel;
    }

    @NotNull
    private static InputStream getLogoImage() throws IOException {
        String currentTheme = JBColor.isBright() ? "light" : "dark";
        ClassLoader classLoader = AbstractSettingsView.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("images/icons/logo-" + currentTheme + "-theme.png");
        if (inputStream == null) {
            throw new IOException("Could not find logo-dark-theme.png");
        }
        InputStream inputStream2 = inputStream;
        if (inputStream2 == null) {
            AbstractSettingsView.$$$reportNull$$$0(0);
        }
        return inputStream2;
    }

    private DocumentListener getDocumentListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AbstractSettingsView.this.setErrorText(null);
                AbstractSettingsView.this.getOKAction().setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo validationInfoEmail;
        String emailText = this.emailInput.getText();
        String passwordText = new String(this.passwordInput.getPassword());
        this.timezone = (String)this.timeZoneComboBox.getSelectedItem();
        if (this.timezone == null) {
            this.timezone = TimeZone.getDefault().getID();
        }
        if ((validationInfoEmail = EmailValidation.isValidEmail(emailText)) != null) {
            return validationInfoEmail;
        }
        HttpResponse<String> response = ApiClient.getToken(emailText, passwordText, this.urlInput.getText(), this.timezone);
        if (response == null) {
            return new ValidationInfo("Response from server null.");
        }
        if (response.statusCode() == 401) {
            return new ValidationInfo("Invalid email or password.");
        }
        if (response.statusCode() == 502) {
            return new ValidationInfo("Bad gateway make sure you are wrote correct url or check connection to the internet.");
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JwtAuthenticationResponseDto responseDto = (JwtAuthenticationResponseDto)objectMapper.readValue(response.body(), JwtAuthenticationResponseDto.class);
            this.token = responseDto.getToken();
            this.refreshToken = responseDto.getRefreshToken();
            ServerSettingsDto serverSettingsDto = ApiClient.getServerSettings(this.urlInput.getText());
            this.isGitEnabled = serverSettingsDto.getGitEnabled();
            this.serverZoneId = serverSettingsDto.getServerZoneId();
            this.visualizationUrl = serverSettingsDto.getVisualizationUrl();
        }
        catch (JsonProcessingException e) {
            return new ValidationInfo("token invalid " + response.body());
        }
        return null;
    }

    protected boolean continuousValidation() {
        return false;
    }

    void showInformationDialog() {
        InformationDialog successDialog = new InformationDialog();
        successDialog.setTitle("Information about project statuses");
        successDialog.setMessageType(1);
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.add((Component)this.getTitlePanel(), "North");
        outerPanel.add((Component)InformationDialog.getInformationPanel(this.isGitEnabled), "Center");
        JPanel eastPanel = new JPanel();
        eastPanel.setPreferredSize(new Dimension(50, 0));
        outerPanel.add((Component)eastPanel, "East");
        successDialog.addComponent(outerPanel);
        successDialog.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kz/pandev/plugins/metrics/ui_dialogs/AbstractSettingsView", "getLogoImage"));
    }
}

