/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.ui_dialogs;

import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import kz.pandev.plugins.metrics.widgets.PanDevStatusBarFactory;

public class InformationDialog {
    private final List<JComponent> components = new ArrayList<JComponent>();
    private String title;
    private int messageType;
    private JRootPane rootPane;
    private String[] options;
    private int optionIndex;

    public InformationDialog() {
        this.setTitle("Custom dialog");
        this.setMessageType(-1);
        this.setRootPane(null);
        this.setOptions(new String[]{"OK"});
        this.setOptionSelection(0);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public void addComponent(JComponent component) {
        this.components.add(component);
    }

    public void setRootPane(JRootPane rootPane) {
        this.rootPane = rootPane;
    }

    public void setOptions(String[] options) {
        this.options = options;
    }

    public void setOptionSelection(int optionIndex) {
        this.optionIndex = optionIndex;
    }

    public void show() {
        int optionType = 2;
        String optionSelection = null;
        if (this.options.length != 0) {
            optionSelection = this.options[this.optionIndex];
        }
        JOptionPane.showOptionDialog(this.rootPane, this.components.toArray(), this.title, optionType, this.messageType, null, this.options, optionSelection);
    }

    public static JPanel getInformationPanel(Boolean isGitEnabled) {
        JPanel statusesPanel = new JPanel(new GridLayout(0, 1));
        Font innerFront = new Font("Inner", 0, 14);
        JPanel activeProjectStatusPanel = new JPanel(new FlowLayout(0));
        JLabel activeProjectStatusIconLabel = new JLabel(PanDevStatusBarFactory.ACTIVE_PROJECT_ICON);
        JLabel activeProjectStatusTextLabel = new JLabel("- project collecting metrics.");
        activeProjectStatusTextLabel.setFont(innerFront);
        activeProjectStatusPanel.add(activeProjectStatusIconLabel);
        activeProjectStatusPanel.add(activeProjectStatusTextLabel);
        statusesPanel.add(activeProjectStatusPanel);
        if (isGitEnabled.booleanValue()) {
            JPanel inactiveProjectStatusPanel = new JPanel(new FlowLayout(0));
            JLabel inactiveProjectStatusIconLabel = new JLabel(PanDevStatusBarFactory.INACTIVE_PROJECT_ICON);
            JLabel inactiveProjectStatusTextLabel = new JLabel("- project does not belong to the company.");
            inactiveProjectStatusTextLabel.setFont(innerFront);
            inactiveProjectStatusPanel.add(inactiveProjectStatusIconLabel);
            inactiveProjectStatusPanel.add(inactiveProjectStatusTextLabel);
            statusesPanel.add(inactiveProjectStatusPanel);
        }
        JPanel issuesProjectStatusPanel = new JPanel(new FlowLayout(0));
        JLabel issuesProjectStatusIconLabel = new JLabel(PanDevStatusBarFactory.SERVER_INACTIVE_ICON);
        JLabel issuesProjectStatusTextLabel = new JLabel("- server or internet issues.");
        issuesProjectStatusTextLabel.setFont(innerFront);
        issuesProjectStatusPanel.add(issuesProjectStatusIconLabel);
        issuesProjectStatusPanel.add(issuesProjectStatusTextLabel);
        statusesPanel.add(issuesProjectStatusPanel);
        return statusesPanel;
    }
}

