/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.utils;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kz.pandev.plugins.metrics.PanDevMetrics;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitInfoProvider {
    private GitInfoProvider() {
    }

    public static String[] getGitBranch(String path) {
        File projectDirectory = new File(Objects.requireNonNull(path));
        File gitFolder = GitInfoProvider.findGitFolder(projectDirectory);
        if (gitFolder != null) {
            String repositoryName = GitInfoProvider.getRepositoryName(gitFolder);
            String branchName = GitInfoProvider.getCurrentBranch(gitFolder);
            return new String[]{repositoryName, branchName};
        }
        return new String[0];
    }

    @Nullable
    public static String getRepositoryName(@NotNull String projectBasePath) {
        File projectDirectory;
        File gitFolder;
        if (projectBasePath == null) {
            GitInfoProvider.$$$reportNull$$$0(0);
        }
        if ((gitFolder = GitInfoProvider.findGitFolder(projectDirectory = new File(Objects.requireNonNull(projectBasePath)))) == null) {
            return null;
        }
        return GitInfoProvider.getRepositoryName(gitFolder);
    }

    public static File findGitFolder(File directory) {
        PanDevMetrics.log.info("Looking for directory: {}", (Object)directory);
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || !".git".equals(file.getName())) continue;
                PanDevMetrics.log.info("Found directory: {}", (Object)file);
                return file;
            }
        }
        return null;
    }

    public static String getRepositoryName(File gitFolder) {
        File configFile = new File(gitFolder, "config");
        if (configFile.exists()) {
            try {
                String configContent = Files.readString(configFile.toPath());
                Pattern pattern = Pattern.compile("\\[remote \"origin\"\\]\\s+url = (.+)");
                Matcher matcher = pattern.matcher(configContent);
                if (matcher.find()) {
                    String remoteUrl = matcher.group(1);
                    String[] parts = remoteUrl.split("/");
                    String repoNameWithExtension = parts[parts.length - 1];
                    return repoNameWithExtension.substring(0, repoNameWithExtension.lastIndexOf(46));
                }
            }
            catch (IOException e) {
                PanDevMetrics.log.error(e.getMessage());
            }
        }
        return null;
    }

    public static String getCurrentBranch(File gitFolder) {
        String string;
        block8: {
            Repository repository = ((RepositoryBuilder)new RepositoryBuilder().setGitDir(gitFolder)).build();
            try {
                string = repository.getBranch();
                if (repository == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    PanDevMetrics.log.error(e.getMessage());
                    return null;
                }
            }
            repository.close();
        }
        return string;
    }

    public static String getModuleGitRepositoryName(Module module) {
        VirtualFile virtualModuleFile = ProjectUtil.guessModuleDir((Module)module);
        if (virtualModuleFile == null) {
            PanDevMetrics.log.info("Virtual module not found: {}", (Object)module);
            return null;
        }
        File moduleGitFile = GitInfoProvider.findGitFolder(new File(virtualModuleFile.getPath()));
        if (moduleGitFile == null) {
            PanDevMetrics.log.info("Module Git File not found: {}", (Object)virtualModuleFile);
            return null;
        }
        return GitInfoProvider.getRepositoryName(moduleGitFile);
    }

    public static String getModuleGitBranch(Module module) {
        VirtualFile virtualModuleFile = ProjectUtil.guessModuleDir((Module)module);
        if (virtualModuleFile == null) {
            return null;
        }
        File moduleGitFile = GitInfoProvider.findGitFolder(new File(virtualModuleFile.getPath()));
        if (moduleGitFile == null) {
            return null;
        }
        return GitInfoProvider.getCurrentBranch(moduleGitFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectBasePath", "kz/pandev/plugins/metrics/utils/GitInfoProvider", "getRepositoryName"));
    }
}

