/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.utils;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class MACAddressUtil {
    public static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                byte[] mac;
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual() || (mac = networkInterface.getHardwareAddress()) == null) continue;
                StringBuilder macAddress = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    macAddress.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                return macAddress.toString();
            }
        }
        catch (SocketException e) {
            return "Error Retrieving MAC address";
        }
        return "MAC address unknown";
    }
}

