/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class SettingsFileReadWriterUtil {
    private SettingsFileReadWriterUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(File configFile, String section, String key) {
        String val = null;
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            String valuePart;
            block11: {
                String line;
                String currentSection = "";
                while ((line = br.readLine()) != null) {
                    int equalsIndex;
                    if ((line = line.trim()).startsWith("[") && line.endsWith("]")) {
                        currentSection = line.substring(1, line.length() - 1).toLowerCase();
                        continue;
                    }
                    if (!currentSection.equalsIgnoreCase(section) || (equalsIndex = line.indexOf(61)) <= 0) continue;
                    String keyPart = line.substring(0, equalsIndex).trim();
                    valuePart = line.substring(equalsIndex + 1).trim();
                    if (!keyPart.equalsIgnoreCase(key)) {
                        continue;
                    }
                    break block11;
                }
                return SettingsFileReadWriterUtil.removeNulls(val);
            }
            String string = SettingsFileReadWriterUtil.removeNulls(valuePart);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return SettingsFileReadWriterUtil.removeNulls(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File configFilePath, String section, String key, String val) {
        key = SettingsFileReadWriterUtil.removeNulls(key);
        val = SettingsFileReadWriterUtil.removeNulls(val);
        StringBuilder contents = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(configFilePath));
            try {
                String currentSection = "";
                String line = br.readLine();
                Boolean found = false;
                while (line != null) {
                    if ((line = SettingsFileReadWriterUtil.removeNulls(line)).trim().startsWith("[") && line.trim().endsWith("]")) {
                        if (section.toLowerCase().equals(currentSection) && !found.booleanValue()) {
                            contents.append(key + " = " + val + "\n");
                            found = true;
                        }
                        currentSection = line.trim().substring(1, line.trim().length() - 1).toLowerCase();
                        contents.append(line + "\n");
                    } else if (section.toLowerCase().equals(currentSection)) {
                        String[] parts = line.split("=");
                        String currentKey = parts[0].trim();
                        if (currentKey.equals(key)) {
                            if (!found.booleanValue()) {
                                contents.append(key + " = " + val + "\n");
                                found = true;
                            }
                        } else {
                            contents.append(line + "\n");
                        }
                    } else {
                        contents.append(line + "\n");
                    }
                    line = br.readLine();
                }
                if (!found.booleanValue()) {
                    if (!section.toLowerCase().equals(currentSection)) {
                        contents.append("[" + section.toLowerCase() + "]\n");
                    }
                    contents.append(key + " = " + val + "\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e1) {
            contents = new StringBuilder();
            contents.append("[" + section.toLowerCase() + "]\n");
            contents.append(key + " = " + val + "\n");
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(configFilePath, "UTF-8");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (writer != null) {
            writer.print(contents.toString());
            writer.close();
        }
    }

    public static String removeNulls(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\u0000", "");
    }
}

