/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.actions;

import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.clients.ApiClient;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.factory.ServerSettingsFactory;
import kz.pandev.plugins.metrics.models.events.DatasourceEvent;
import kz.pandev.plugins.metrics.utils.JsonUtils;
import kz.pandev.plugins.metrics.utils.PandevFileUtils;

public final class DatabaseActions {
    private DatabaseActions() {
        throw new UnsupportedOperationException("DataBaseActions class cannot be instantiated! - UtilityClass");
    }

    public static void init() {
        DatabaseActions.initQueueProcessor();
    }

    private static void initQueueProcessor() {
        PanDevMetrics.log.info("QueueProcessor DB actions started");
        Runnable handler = DatabaseActions::processEvents;
        long delay = 90L;
        AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(handler, delay, delay, TimeUnit.SECONDS);
    }

    private static void processEvents() {
        for (ServerSettings serverSetting : ServerSettingsFactory.getAllServerSettings()) {
            Queue<DatasourceEvent> queue = serverSetting.getEventDbQueue();
            ArrayList<DatasourceEvent> newEvents = new ArrayList<DatasourceEvent>();
            if (queue.isEmpty()) {
                return;
            }
            while (!serverSetting.getEventDbQueue().isEmpty()) {
                DatasourceEvent event = queue.poll();
                newEvents.add(event);
            }
            DatabaseActions.sendEvent(serverSetting, newEvents);
        }
    }

    private static void sendEvent(ServerSettings settings, List<DatasourceEvent> newEvents) {
        try {
            DatabaseActions.sendEventsToServer(newEvents, settings);
            DatabaseActions.sendEventsToServer(DatabaseActions.readObjectsFromFile(settings.getQueueFile(false)), settings);
            PandevFileUtils.clearTextFile(settings.getQueueFile(false));
        }
        catch (IOException e) {
            DatabaseActions.addJsonObjectToFile(settings.getQueueFile(false), newEvents);
        }
        catch (InterruptedException e) {
            DatabaseActions.addJsonObjectToFile(settings.getQueueFile(false), newEvents);
            Thread.currentThread().interrupt();
        }
    }

    public static List<DatasourceEvent> readObjectsFromFile(File file) throws IOException {
        ArrayList<DatasourceEvent> existingObjects = new ArrayList<DatasourceEvent>();
        if (file.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                char[] buffer = new char[(int)file.length()];
                reader.read(buffer);
                String json = new String(buffer);
                json = json.substring(0, json.lastIndexOf("]") + 1);
                DatasourceEvent[] objectsArray = JsonUtils.fromJson(json, DatasourceEvent[].class);
                if (objectsArray != null) {
                    Collections.addAll(existingObjects, objectsArray);
                }
            }
            catch (Exception e) {
                throw new IOException("Error while decrypting data", e);
            }
        }
        return existingObjects;
    }

    public static void writeObjectsToFile(List<DatasourceEvent> dEvents, File file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            String json = JsonUtils.toJson(dEvents);
            writer.write(json);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void addJsonObjectToFile(File file, List<DatasourceEvent> events) {
        if (file == null || events == null) {
            throw new IllegalArgumentException("File or heartbeat list is null");
        }
        try {
            List<DatasourceEvent> existingObjects = DatabaseActions.readObjectsFromFile(file);
            existingObjects.addAll(events);
            DatabaseActions.writeObjectsToFile(existingObjects, file);
        }
        catch (IOException e) {
            PanDevMetrics.log.error("Error while adding object to file", (Throwable)e);
        }
    }

    private static void sendEventsToServer(List<DatasourceEvent> events, ServerSettings serverSettings) throws IOException, InterruptedException {
        ApiClient.sendEventsToServer(serverSettings, events, "/v2/datasource");
    }
}

