/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.clients;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.models.JwtAuthenticationResponseDto;
import kz.pandev.plugins.metrics.models.JwtTokenDto;
import kz.pandev.plugins.metrics.models.ProjectOwnershipStatus;
import kz.pandev.plugins.metrics.models.ProjectOwnershipStatusResponseDto;
import kz.pandev.plugins.metrics.models.ServerSettingsDto;
import kz.pandev.plugins.metrics.models.SignInRequest;
import kz.pandev.plugins.metrics.models.UserActivityByDateAndProjectDto;
import kz.pandev.plugins.metrics.models.UserQuickDateDto;
import kz.pandev.plugins.metrics.models.events.DatasourceEvent;
import kz.pandev.plugins.metrics.utils.IPAddressUtil;
import kz.pandev.plugins.metrics.utils.JsonUtils;
import kz.pandev.plugins.metrics.utils.MACAddressUtil;
import kz.pandev.plugins.metrics.widgets.PanDevStatusbarWidget;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.http.HttpException;

public class ApiClient {
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    private static final String APPLICATION_CONTENT_TYPE = "application/json";
    private static final String EXCEPTION_MESSAGE = "The server responded with an error code: ";

    private ApiClient() {
    }

    public static void sendEventsToServer(ServerSettings serverSettings, List<DatasourceEvent> events, String apiPath) throws IOException, InterruptedException {
        String json = JsonUtils.toJson(events);
        String url = serverSettings.getUrl();
        String headerValue = serverSettings.getAuthenticationHeader();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url + apiPath)).header("Content-Type", APPLICATION_CONTENT_TYPE).header("Authorization", headerValue).POST(HttpRequest.BodyPublishers.ofString(json)).timeout(Duration.of(30L, ChronoUnit.SECONDS)).build();
        ApiClient.sendRequest(request, serverSettings);
    }

    public static void sendJsonStringToServer(ServerSettings serverSettings, String json) throws IOException, InterruptedException {
        String url = serverSettings.getUrl();
        String email = serverSettings.getEmail();
        String headerValue = serverSettings.getAuthenticationHeader();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url + "/v3/handler?email=" + email)).header("Content-Type", APPLICATION_CONTENT_TYPE).header("Authorization", headerValue).POST(HttpRequest.BodyPublishers.ofString(json)).timeout(Duration.of(30L, ChronoUnit.SECONDS)).build();
        ApiClient.sendRequest(request, serverSettings);
    }

    public static HttpResponse<String> getToken(String email, String password, String url, String timezone) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url + "/auth/sign-in")).header("Content-Type", APPLICATION_CONTENT_TYPE).POST(HttpRequest.BodyPublishers.ofString(ApiClient.getUserDataAsJson(email, password, timezone))).timeout(Duration.of(10L, ChronoUnit.SECONDS)).build();
        try {
            return HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException e) {
            PanDevMetrics.log.error(e.getMessage());
        }
        catch (InterruptedException e) {
            PanDevMetrics.log.error(e.getMessage());
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public static void refreshToken(ServerSettings serverSettings) throws IOException {
        try {
            String url = serverSettings.getUrl();
            ObjectMapper objectMapper = new ObjectMapper();
            JwtTokenDto jwtTokenDto = new JwtTokenDto();
            jwtTokenDto.setToken(serverSettings.getRefreshToken());
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url + "/v1/auth/refresh-token")).header("Content-Type", APPLICATION_CONTENT_TYPE).POST(HttpRequest.BodyPublishers.ofString(objectMapper.writeValueAsString((Object)jwtTokenDto))).timeout(Duration.of(10L, ChronoUnit.SECONDS)).build();
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response != null && response.statusCode() != 200) {
                serverSettings.saveSettings("settings", Map.of("token", ""));
            } else if (response != null && response.statusCode() == 200) {
                JwtAuthenticationResponseDto responseDto = (JwtAuthenticationResponseDto)objectMapper.readValue(response.body(), JwtAuthenticationResponseDto.class);
                serverSettings.saveSettings("settings", Map.of("token", responseDto.getToken(), "refresh_token", responseDto.getRefreshToken()));
            }
        }
        catch (InterruptedException e) {
            PanDevMetrics.log.error(e.getMessage());
            Thread.currentThread().interrupt();
        }
        throw new IOException();
    }

    private static HttpResponse<String> sendGetRequest(String url, ServerSettings serverSettings) throws IOException, InterruptedException {
        String authenticationHeader = serverSettings.getAuthenticationHeader();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", APPLICATION_CONTENT_TYPE).header("Authorization", authenticationHeader).GET().timeout(Duration.of(5L, ChronoUnit.SECONDS)).build();
        return ApiClient.sendRequest(request, serverSettings);
    }

    private static HttpResponse<String> sendRequest(HttpRequest request, ServerSettings serverSettings) throws IOException, InterruptedException {
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response != null && (response.statusCode() == 403 || response.statusCode() == 401)) {
            PanDevMetrics.log.error("Refreshing token");
            ApiClient.refreshToken(serverSettings);
            throw new IOException();
        }
        if (response == null || response.statusCode() != 200) {
            PanDevMetrics.log.error("Request failed to url {}", (Object)request.uri());
            throw new IOException();
        }
        return response;
    }

    private static String getUserDataAsJson(String email, String password, String timezone) {
        String jsonString;
        SignInRequest signInRequest = new SignInRequest();
        signInRequest.setUsername(email);
        signInRequest.setPassword(password);
        signInRequest.setUserTimeZone(timezone);
        signInRequest.setSystemTimeZone(TimeZone.getDefault().getID());
        signInRequest.setIpAddress(IPAddressUtil.getPublicIPAddress());
        signInRequest.setMacAddress(MACAddressUtil.getMacAddress());
        String country = Locale.getDefault().getDisplayCountry(Locale.ENGLISH);
        signInRequest.setCountry(country);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            jsonString = objectMapper.writeValueAsString((Object)signInRequest);
        }
        catch (JsonProcessingException e) {
            return "";
        }
        return jsonString;
    }

    public static UserQuickDateDto fetchUserBetweenDates(LocalDate startDate, LocalDate endDate, ServerSettings serverSettings) throws IOException, InterruptedException {
        String baseUrl = serverSettings.getUrl();
        String email = serverSettings.getEmail();
        String url = baseUrl + "/user/between-dates?email=" + email + "&startDate=" + startDate + "&endDate=" + endDate;
        try {
            HttpResponse<String> response = ApiClient.sendGetRequest(url, serverSettings);
            if (response.statusCode() != 200) {
                throw new IOException(EXCEPTION_MESSAGE + response.statusCode());
            }
            ObjectMapper mapper = new ObjectMapper();
            return (UserQuickDateDto)mapper.readValue(response.body(), UserQuickDateDto.class);
        }
        catch (IOException | InterruptedException e) {
            PanDevMetrics.log.error("Failed to fetch user between dates: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public static UserActivityByDateAndProjectDto fetchUserActivityByProjects(ServerSettings serverSettings, LocalDate date, String ... projectNames) throws IOException, InterruptedException {
        String baseUrl = serverSettings.getUrl();
        String email = serverSettings.getSettings("settings", "email");
        String joinedProjectNames = String.join((CharSequence)",", projectNames);
        String url = baseUrl + "/user/by-projects/by-date?email=" + email + "&date=" + date + "&projectNames=" + joinedProjectNames;
        try {
            HttpResponse<String> response = ApiClient.sendGetRequest(url, serverSettings);
            if (response.statusCode() != 200) {
                throw new IOException(EXCEPTION_MESSAGE + response.statusCode());
            }
            ObjectMapper mapper = new ObjectMapper();
            return (UserActivityByDateAndProjectDto)mapper.readValue(response.body(), UserActivityByDateAndProjectDto.class);
        }
        catch (IOException | InterruptedException e) {
            PanDevMetrics.log.error("Error while fetching user activity by projects from host: {}", (Object)serverSettings.getUrl(), (Object)e);
            throw e;
        }
    }

    public static Map<String, PanDevStatusbarWidget.ModuleStatus.Status> isProjectsBelongsToCompany(ServerSettings serverSettings, MultiValueMap modulesPaths) throws IOException, InterruptedException, HttpException {
        String joinedProjectNames = String.join((CharSequence)",", modulesPaths.keySet());
        String baseUrl = serverSettings.getUrl();
        String url = baseUrl + "/is-project-belongs?projectNames=" + joinedProjectNames;
        HttpResponse<String> projectBelongsResponse = ApiClient.sendGetRequest(url, serverSettings);
        if (projectBelongsResponse.statusCode() != 200) {
            throw new HttpException(EXCEPTION_MESSAGE + projectBelongsResponse.statusCode());
        }
        ObjectMapper objectMapper = new ObjectMapper();
        ProjectOwnershipStatusResponseDto ownershipStatusResponseDto = (ProjectOwnershipStatusResponseDto)objectMapper.readValue(projectBelongsResponse.body(), ProjectOwnershipStatusResponseDto.class);
        PanDevMetrics.log.info("Correct response from API endpoint is-project-belongs");
        if (Objects.isNull(ownershipStatusResponseDto) || ownershipStatusResponseDto.getProjects().isEmpty()) {
            throw new HttpException("Response from server is null or empty");
        }
        HashMap<String, PanDevStatusbarWidget.ModuleStatus.Status> projectsBelongsToCompanyMap = new HashMap<String, PanDevStatusbarWidget.ModuleStatus.Status>();
        for (ProjectOwnershipStatus ownershipStatus : ownershipStatusResponseDto.getProjects()) {
            for (Object entry : modulesPaths.entrySet()) {
                Collection moduleNames = (Collection)((Map.Entry)entry).getValue();
                for (String moduleName : moduleNames) {
                    projectsBelongsToCompanyMap.put(moduleName, ownershipStatus.isBelongs() ? PanDevStatusbarWidget.ModuleStatus.Status.ACTIVE : PanDevStatusbarWidget.ModuleStatus.Status.INACTIVE);
                }
            }
        }
        return projectsBelongsToCompanyMap;
    }

    public static ServerSettingsDto getServerSettings(String baseUrl) {
        String url = baseUrl + "/server-settings";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().timeout(Duration.of(5L, ChronoUnit.SECONDS)).build();
        try {
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            ObjectMapper mapper = new ObjectMapper();
            return (ServerSettingsDto)mapper.readValue(response.body(), ServerSettingsDto.class);
        }
        catch (IOException e) {
            PanDevMetrics.log.error("Error while fetching user activity by projects", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return new ServerSettingsDto();
    }
}

