/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.configs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.configs.AuthenticationType;
import kz.pandev.plugins.metrics.configs.LoginPasswordSettingsConfig;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.models.Heartbeat;
import kz.pandev.plugins.metrics.models.events.DatasourceEvent;
import kz.pandev.plugins.metrics.utils.SettingsFileReadWriterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginPasswordSettings
implements ServerSettings {
    public static final String EMAIL_KEY = "email";
    public static final String TOKEN_KEY = "token";
    public static final String REFRESH_TOKEN_KEY = "refresh_token";
    public static final String URL_KEY = "url";
    public static final String TIMEZONE_KEY = "timezone";
    public static final String SERVER_ZONE_ID_KEY = "server_zone_id";
    public static final String DATABASE_ENDPOINT_PATH = "/v2/datasource";
    public static final String VISUALIZATION_URL_KEY = "visualization_url";
    private static final String DB = "_db";
    private static final Logger log = LoggerFactory.getLogger(LoginPasswordSettings.class);
    private String cachedHomeFolder = null;
    private final String fileName;
    private File settingsFile;
    private final String internalFileName;
    private File queueFile;
    private File dbQueueFile;
    private Boolean debug = false;
    private Boolean statusBarEnabled = false;
    private Boolean gitEnabled;
    private final String domain;
    private String email;
    private String url;
    private String token;
    private String refreshToken;
    private String timezone;
    private String serverZoneId;
    private String visualizationUrl;
    public final Queue<Heartbeat> heartbeatsQueue = new ConcurrentLinkedQueue<Heartbeat>();
    private final Queue<DatasourceEvent> eventDbQueue = new ConcurrentLinkedQueue<DatasourceEvent>();

    public LoginPasswordSettings(LoginPasswordSettingsConfig config) {
        this.url = config.getUrl();
        this.email = config.getEmail();
        this.token = config.getToken();
        this.refreshToken = config.getRefreshToken();
        this.timezone = config.getTimezone();
        this.domain = ServerSettings.getDomainInUrl(this.url);
        this.fileName = this.domain + "_pandev_metrics.cfg";
        this.internalFileName = this.domain + "_pandev_metrics_internal.cfg";
        this.statusBarEnabled = config.isStatusBarEnabled();
        this.gitEnabled = config.isGitEnabled();
        this.serverZoneId = config.getServerZoneId();
        this.visualizationUrl = config.getVisualizationUrl();
        this.saveSettings("settings", Map.of(URL_KEY, this.url, EMAIL_KEY, this.email, TOKEN_KEY, this.token, REFRESH_TOKEN_KEY, this.refreshToken, TIMEZONE_KEY, this.timezone, SERVER_ZONE_ID_KEY, this.serverZoneId, VISUALIZATION_URL_KEY, this.visualizationUrl, "status_bar_enabled", config.isStatusBarEnabled() ? "true" : "false", "debug", Boolean.TRUE.equals(this.debug) ? "true" : "false", "git", Boolean.TRUE.equals(this.gitEnabled) ? "true" : "false"));
        this.getQueueFile(false);
        this.getDbQueueFile(false);
    }

    public LoginPasswordSettings(String domain) {
        this.domain = domain;
        this.fileName = this.domain + "_pandev_metrics.cfg";
        this.internalFileName = this.domain + "_pandev_metrics_internal.cfg";
        this.url = this.getSettings("settings", URL_KEY);
        this.email = this.getSettings("settings", EMAIL_KEY);
        this.token = this.getSettings("settings", TOKEN_KEY);
        this.refreshToken = this.getSettings("settings", REFRESH_TOKEN_KEY);
        this.timezone = this.getSettings("settings", TIMEZONE_KEY);
        this.serverZoneId = this.getSettings("settings", SERVER_ZONE_ID_KEY);
        this.visualizationUrl = this.getSettings("settings", VISUALIZATION_URL_KEY);
        this.statusBarEnabled = Objects.equals(this.getSettings("settings", "status_bar_enabled"), "true");
        this.debug = Objects.equals(this.getSettings("settings", "debug"), "true");
        this.gitEnabled = Objects.equals(this.getSettings("settings", "git"), "true");
    }

    @Override
    public void saveSettings(String section, Map<String, String> settings) {
        block24: for (Map.Entry<String, String> entry : settings.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            SettingsFileReadWriterUtil.write(this.getConfigFile(false), section, key, value);
            switch (key) {
                case "email": {
                    this.email = value;
                    continue block24;
                }
                case "token": {
                    this.token = value;
                    continue block24;
                }
                case "refresh_token": {
                    this.refreshToken = value;
                    continue block24;
                }
                case "url": {
                    this.url = value;
                    continue block24;
                }
                case "timezone": {
                    this.timezone = value;
                    continue block24;
                }
                case "server_zone_id": {
                    this.serverZoneId = value;
                    continue block24;
                }
                case "visualization_url": {
                    this.visualizationUrl = value;
                    continue block24;
                }
                case "status_bar_enabled": {
                    this.statusBarEnabled = Boolean.parseBoolean(value);
                    continue block24;
                }
                case "debug": {
                    this.debug = Boolean.parseBoolean(value);
                    continue block24;
                }
                case "git": {
                    this.gitEnabled = Boolean.parseBoolean(value);
                    continue block24;
                }
            }
            log.warn("No key found");
        }
    }

    @Override
    public String getSettings(String section, String key) {
        String value = switch (key) {
            case EMAIL_KEY -> this.email;
            case TOKEN_KEY -> this.token;
            case REFRESH_TOKEN_KEY -> this.refreshToken;
            case URL_KEY -> this.url;
            case TIMEZONE_KEY -> this.timezone;
            case SERVER_ZONE_ID_KEY -> this.serverZoneId;
            case VISUALIZATION_URL_KEY -> this.visualizationUrl;
            default -> null;
        };
        return value != null ? value : SettingsFileReadWriterUtil.read(this.getConfigFile(false), section, key);
    }

    @Override
    public Queue<Heartbeat> getHeartbeatsQueue() {
        return this.heartbeatsQueue;
    }

    @Override
    public File getConfigFile(boolean internal) {
        if (!internal && this.settingsFile != null) {
            return this.settingsFile;
        }
        if (this.cachedHomeFolder == null) {
            File folder;
            if (System.getenv("PANDEV_METRICS_HOME") != null && !System.getenv("PANDEV_METRICS_HOME").trim().isEmpty() && (folder = new File(System.getenv("PANDEV_METRICS_HOME"))).exists()) {
                this.cachedHomeFolder = folder.getAbsolutePath();
                PanDevMetrics.log.debug("Using $PANDEV_METRICS_HOME for config folder: {}", (Object)this.cachedHomeFolder);
                if (internal) {
                    return new File(new File(this.cachedHomeFolder, ".pandev_metrics"), this.internalFileName);
                }
                this.settingsFile = new File(this.cachedHomeFolder, this.fileName);
                return this.settingsFile;
            }
            this.cachedHomeFolder = new File(System.getProperty("user.home")).getAbsolutePath();
            PanDevMetrics.log.debug("Using $HOME for config folder: {}", (Object)this.cachedHomeFolder);
        }
        if (internal) {
            return new File(new File(this.cachedHomeFolder, ".pandev_metrics"), this.internalFileName);
        }
        this.settingsFile = new File(this.cachedHomeFolder, this.fileName);
        return this.settingsFile;
    }

    @Override
    public final File getQueueFile(boolean internal) {
        return this.getFile(internal, this.queueFile, this.domain);
    }

    @Override
    public final File getDbQueueFile(boolean internal) {
        return this.getFile(internal, this.dbQueueFile, this.domain + DB);
    }

    private File getFile(boolean internal, File existingFile, String domainPrefix) {
        if (!internal && existingFile != null) {
            return existingFile;
        }
        String currentDir = System.getProperty("user.home");
        String filePath = currentDir + File.separator + domainPrefix + "_queue.json";
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                Files.createFile(Path.of(filePath, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                PanDevMetrics.log.error(e.getMessage());
            }
        }
        return file;
    }

    @Override
    public Queue<DatasourceEvent> getEventDbQueue() {
        return this.eventDbQueue;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public AuthenticationType getAuthenticationType() {
        return AuthenticationType.LOGIN_PASSWORD;
    }

    @Override
    public boolean isConfigured() {
        return Stream.of(URL_KEY, EMAIL_KEY, TOKEN_KEY, REFRESH_TOKEN_KEY, SERVER_ZONE_ID_KEY, "git", TIMEZONE_KEY, VISUALIZATION_URL_KEY, "status_bar_enabled").map(key -> this.getSettings("settings", (String)key)).noneMatch(value -> value == null || value.isEmpty());
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getServerZoneId() {
        return this.serverZoneId;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getVisualizationUrl() {
        return this.visualizationUrl;
    }

    @Override
    public String getAuthenticationHeader() {
        return "Bearer " + this.token;
    }

    @Override
    public boolean isStatusBarEnabled() {
        return this.statusBarEnabled;
    }

    @Override
    public boolean isGitEnabled() {
        return this.gitEnabled;
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }
}

