/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.factory;

import com.intellij.openapi.util.text.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.configs.AuthenticationType;
import kz.pandev.plugins.metrics.configs.LoginPasswordSettings;
import kz.pandev.plugins.metrics.configs.LoginPasswordSettingsConfig;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.utils.SettingsFileReadWriterUtil;

public class ServerSettingsFactory {
    private static final Map<String, ServerSettings> serverConcurrentHashMap = new ConcurrentHashMap<String, ServerSettings>();
    public static final String FILE_NAME = "metrics_servers.cfg";
    public static final String SERVERS_LIST_KEY = "servers";
    private static String cachedHomeFolder = null;

    private ServerSettingsFactory() {
    }

    public static ServerSettings createServerSettings(String domain, Map<String, String> settings, AuthenticationType authenticationType) {
        if (serverConcurrentHashMap.containsKey(domain)) {
            return serverConcurrentHashMap.get(domain);
        }
        if (authenticationType == AuthenticationType.LOGIN_PASSWORD) {
            LoginPasswordSettingsConfig config = new LoginPasswordSettingsConfig(settings.get("url"), settings.get("email"), settings.get("token"), settings.get("refresh_token"), settings.get("timezone"), settings.get("server_zone_id"), settings.get("visualization_url"), Objects.equals(settings.get("status_bar_enabled"), "true"), Objects.equals(settings.get("git"), "true"));
            LoginPasswordSettings newServerSettings = new LoginPasswordSettings(config);
            ServerSettingsFactory.addDomainToServersFile(domain, authenticationType);
            serverConcurrentHashMap.put(domain, newServerSettings);
            return newServerSettings;
        }
        return null;
    }

    public static ServerSettings getInstance(String domain) {
        return serverConcurrentHashMap.get(domain);
    }

    public static void initServers() {
        File configFile = ServerSettingsFactory.getConfigFile(false);
        if (configFile.exists()) {
            for (AuthenticationType authType : AuthenticationType.values()) {
                String servers = SettingsFileReadWriterUtil.read(configFile, AuthenticationType.LOGIN_PASSWORD.toString(), SERVERS_LIST_KEY);
                for (String server : servers.split(" ")) {
                    if (authType != AuthenticationType.LOGIN_PASSWORD) continue;
                    serverConcurrentHashMap.put(server, new LoginPasswordSettings(server));
                }
            }
        }
    }

    private static File getConfigFile(boolean internal) {
        if (cachedHomeFolder == null) {
            File folder;
            if (System.getenv("PANDEV_METRICS_HOME") != null && !System.getenv("PANDEV_METRICS_HOME").trim().isEmpty() && (folder = new File(System.getenv("PANDEV_METRICS_HOME"))).exists()) {
                cachedHomeFolder = folder.getAbsolutePath();
                PanDevMetrics.log.debug("Using $PANDEV_METRICS_HOME for config folder: {}", (Object)cachedHomeFolder);
                if (internal) {
                    return new File(new File(cachedHomeFolder, ".pandev_metrics"), FILE_NAME);
                }
                return new File(cachedHomeFolder, FILE_NAME);
            }
            cachedHomeFolder = new File(System.getProperty("user.home")).getAbsolutePath();
            PanDevMetrics.log.debug("Using $HOME for config folder: {}", (Object)cachedHomeFolder);
        }
        if (internal) {
            return new File(new File(cachedHomeFolder, ".pandev_metrics"), FILE_NAME);
        }
        return new File(cachedHomeFolder, FILE_NAME);
    }

    public static String[] getAllDomainUrls() {
        ArrayList<String> allDomainUrls = new ArrayList<String>();
        for (Map.Entry<String, ServerSettings> entry : serverConcurrentHashMap.entrySet()) {
            ServerSettings serverSetting = entry.getValue();
            if (serverSetting == null) continue;
            allDomainUrls.add(serverSetting.getUrl());
        }
        return allDomainUrls.toArray(new String[0]);
    }

    public static String[] getAllDomains() {
        return serverConcurrentHashMap.keySet().toArray(new String[0]);
    }

    public static void removeServer(String selectedServer, AuthenticationType authenticationType) throws IOException {
        ServerSettings currentServerSettings = serverConcurrentHashMap.get(selectedServer);
        if (currentServerSettings != null) {
            serverConcurrentHashMap.remove(selectedServer);
            File configFile = currentServerSettings.getConfigFile(false);
            File queueFile = currentServerSettings.getQueueFile(false);
            File queueDbFile = currentServerSettings.getDbQueueFile(false);
            ServerSettingsFactory.deleteFileIfExists(configFile.toPath());
            ServerSettingsFactory.deleteFileIfExists(queueFile.toPath());
            ServerSettingsFactory.deleteFileIfExists(queueDbFile.toPath());
            ServerSettingsFactory.removeDomainFromServersFile(selectedServer, authenticationType);
        }
    }

    private static void deleteFileIfExists(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        } else {
            PanDevMetrics.log.warn("File not found for deletion: {}", (Object)path.toAbsolutePath());
        }
    }

    private static void removeDomainFromServersFile(String domain, AuthenticationType authenticationType) {
        String servers = SettingsFileReadWriterUtil.read(ServerSettingsFactory.getConfigFile(false), authenticationType.toString(), SERVERS_LIST_KEY);
        ArrayList<String> domainList = new ArrayList<String>(Arrays.stream(servers.split(" ")).toList());
        domainList.remove(domain);
        SettingsFileReadWriterUtil.write(ServerSettingsFactory.getConfigFile(false), authenticationType.toString(), SERVERS_LIST_KEY, Strings.join(domainList, (String)" "));
    }

    private static void addDomainToServersFile(String domain, AuthenticationType authenticationType) {
        String servers = SettingsFileReadWriterUtil.read(ServerSettingsFactory.getConfigFile(false), authenticationType.toString(), SERVERS_LIST_KEY);
        ArrayList<Object> domainList = servers != null ? new ArrayList<String>(Arrays.stream(servers.split(" ")).toList()) : new ArrayList();
        if (!domainList.contains(domain)) {
            domainList.add(domain);
            SettingsFileReadWriterUtil.write(ServerSettingsFactory.getConfigFile(false), authenticationType.toString(), SERVERS_LIST_KEY, Strings.join(domainList, (String)" "));
        }
    }

    public static Collection<ServerSettings> getAllServerSettings() {
        return serverConcurrentHashMap.values();
    }

    public static ServerSettings getDefaultServerSettings() {
        if (serverConcurrentHashMap.isEmpty()) {
            return null;
        }
        return serverConcurrentHashMap.values().iterator().next();
    }

    public static ServerSettings getServerSettingsByDomain(String domain) {
        for (ServerSettings serverSettings : serverConcurrentHashMap.values()) {
            if (!serverSettings.getDomain().equals(domain)) continue;
            return serverSettings;
        }
        return null;
    }
}

