/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.ui_dialogs;

import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kz.pandev.plugins.metrics.PanDevMetrics;

public class LinkPane
extends JTextPane {
    private final String url;

    public LinkPane(String url, String text) {
        this.url = url;
        this.setEditable(false);
        this.addHyperlinkListener(new UrlHyperlinkListener());
        this.setContentType("text/html");
        this.setBackground((Color)new JBColor(new Color(0, 0, 0, 0), new Color(0, 0, 0, 0)));
        this.setText(text);
    }

    @Override
    public void setText(String text) {
        super.setText("<html><body style=\"text-align:center;\"><a href=\"" + this.url + "\" style=\"font-size: 9 px; font-weight: normal;\">" + text + "</a></body></html>");
    }

    private static class UrlHyperlinkListener
    implements HyperlinkListener {
        private UrlHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(event.getURL().toURI());
                }
                catch (IOException | URISyntaxException e) {
                    PanDevMetrics.log.error("Can't open URL {}", (Object)e.getMessage());
                }
            }
        }
    }
}

