/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.ui_dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import java.awt.Component;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.configs.AuthenticationType;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.factory.ServerSettingsFactory;
import kz.pandev.plugins.metrics.ui_dialogs.AbstractSettingsView;
import kz.pandev.plugins.metrics.ui_dialogs.LinkPane;
import kz.pandev.plugins.metrics.widgets.PanDevStatusbarWidget;
import org.jetbrains.annotations.Nullable;

public class LoginPage
extends AbstractSettingsView {
    public LoginPage(@Nullable Project project) {
        super(project);
        this.setSize(700, 400);
        this.setTitle("Login");
        this.setOKButtonText("Save");
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 1));
        JPanel companyInfoLinkPanel = new JPanel();
        JLabel companyInfoLabel = new JLabel("About our company");
        LinkPane companyLink = new LinkPane("https://pandev.kz/", " here");
        companyInfoLinkPanel.add(companyInfoLabel);
        companyInfoLinkPanel.add(companyLink);
        outerPanel.add(companyInfoLinkPanel);
        outerPanel.add(this.reportProblemLinkPanel);
        this.mainPanel.add((Component)outerPanel, "South");
        this.init();
    }

    @Override
    @Nullable
    protected ValidationInfo doValidate() {
        String urlPattern = "^https?://[a-zA-Z0-9-\\.]+(?:\\:\\d+)?$";
        Pattern compile = Pattern.compile(urlPattern);
        Matcher matcherUrl = compile.matcher(this.urlInput.getText());
        if (!matcherUrl.matches()) {
            return new ValidationInfo("Invalid url.", (JComponent)this.urlInput);
        }
        return super.doValidate();
    }

    public void doOKAction() {
        ServerSettings newServerSettings = ServerSettingsFactory.createServerSettings(ServerSettings.getDomainInUrl(this.urlInput.getText()), Map.of("url", this.urlInput.getText(), "email", this.loginInput.getText(), "token", this.token, "refresh_token", this.refreshToken, "timezone", this.timezone, "server_zone_id", this.serverZoneId, "visualization_url", this.visualizationUrl, "status_bar_enabled", "true", "debug", "false", "git", String.valueOf(this.isGitEnabled)), AuthenticationType.LOGIN_PASSWORD);
        for (Project openProject : Objects.requireNonNull(ProjectManager.getInstanceIfCreated()).getOpenProjects()) {
            StatusBarWidget widget;
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(openProject);
            if (statusBar == null || (widget = statusBar.getWidget(newServerSettings.getDomain())) != null) continue;
            PanDevStatusbarWidget newWidget = new PanDevStatusbarWidget(openProject, newServerSettings.getDomain());
            statusBar.addWidget((StatusBarWidget)newWidget);
        }
        PanDevMetrics.initStatusBar();
        super.doOKAction();
        this.showInformationDialog();
    }

    public void promptForEmail() {
        this.show();
    }
}

