/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.ui_dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import java.awt.Component;
import java.io.IOException;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.configs.AuthenticationType;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.factory.ServerSettingsFactory;
import kz.pandev.plugins.metrics.ui_dialogs.AbstractSettingsView;
import kz.pandev.plugins.metrics.ui_dialogs.AddServerDialog;
import kz.pandev.plugins.metrics.ui_dialogs.LinkPane;
import org.jetbrains.annotations.Nullable;

public class Settings
extends AbstractSettingsView {
    private final JCheckBox debug;
    private final JCheckBox statusBar;
    protected final JButton addServerButton;
    private final JButton deleteServerButton;
    private final JComboBox<String> serverComboBox;
    private ServerSettings currentDomain;
    private final Project project;

    public Settings(@Nullable Project project, ServerSettings serverSettings) {
        super(project);
        this.project = project;
        this.setSize(700, 400);
        this.setTitle("Settings");
        this.setOKButtonText("Save");
        this.currentDomain = serverSettings;
        JLabel serverLabel = new JLabel("Select Server:", 0);
        this.serverComboBox = new ComboBox((Object[])ServerSettingsFactory.getAllDomains());
        this.serverComboBox.setSelectedItem(this.currentDomain.getDomain());
        this.serverComboBox.addActionListener(e -> this.updateFieldsBasedOnSelectedServer());
        this.userInfoFormPanel.add((Component)serverLabel, 1);
        this.userInfoFormPanel.add((Component)this.serverComboBox, 2);
        this.urlInput.setVisible(false);
        this.urlInput.setText(this.currentDomain.getUrl());
        this.loginInput.setText(this.currentDomain.getSettings("settings", "email"));
        this.timeZoneComboBox.setSelectedItem(this.currentDomain.getSettings("settings", "timezone"));
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 1));
        JPanel statusBarPanel = new JPanel();
        JLabel statusBarLabel = new JLabel("Show PanDev Metrics in status bar:");
        statusBarPanel.add(statusBarLabel);
        String statusBarValue = this.currentDomain.getSettings("settings", "status_bar_enabled");
        this.statusBar = new JCheckBox();
        this.statusBar.setSelected(statusBarValue == null || !statusBarValue.trim().equalsIgnoreCase("false"));
        statusBarPanel.add(this.statusBar);
        JPanel debugPanel = new JPanel();
        JLabel debugLabel = new JLabel("Debug:");
        debugPanel.add(debugLabel);
        String debugValue = this.currentDomain.getSettings("settings", "debug");
        this.debug = new JCheckBox();
        this.debug.setSelected(debugValue != null && debugValue.trim().equalsIgnoreCase("true"));
        debugPanel.add(this.debug);
        JPanel companyInfoLinkPanel = new JPanel();
        JLabel companyInfoLabel = new JLabel("About our company");
        LinkPane companyLink = new LinkPane("https://pandev.kz/", " here");
        companyInfoLinkPanel.add(companyInfoLabel);
        companyInfoLinkPanel.add(companyLink);
        outerPanel.add(statusBarPanel);
        outerPanel.add(debugPanel);
        outerPanel.add(companyInfoLinkPanel);
        outerPanel.add(this.reportProblemLinkPanel);
        JPanel buttonPanel = new JPanel();
        this.addServerButton = new JButton("Add Server");
        this.addServerButton.addActionListener(e -> this.openAddServerDialog());
        buttonPanel.add(this.addServerButton);
        this.deleteServerButton = new JButton("Delete Server");
        this.deleteServerButton.addActionListener(e -> this.deleteSelectedServer());
        buttonPanel.add(this.deleteServerButton);
        outerPanel.add(buttonPanel);
        this.updateDeleteButtonState();
        this.mainPanel.add((Component)outerPanel, "South");
        this.init();
    }

    public void doOKAction() {
        this.currentDomain.saveSettings("settings", Map.of("url", this.urlInput.getText(), "email", this.loginInput.getText(), "token", this.token, "refresh_token", this.refreshToken, "timezone", this.timezone, "git", String.valueOf(this.isGitEnabled), "visualization_url", this.visualizationUrl, "server_zone_id", this.serverZoneId, "debug", this.debug.isSelected() ? "true" : "false", "status_bar_enabled", this.statusBar.isSelected() ? "true" : "false"));
        PanDevMetrics.initStatusBar();
        super.doOKAction();
        this.showInformationDialog();
    }

    private void updateFieldsBasedOnSelectedServer() {
        String selectedServer = (String)this.serverComboBox.getSelectedItem();
        ServerSettings settings = ServerSettingsFactory.getInstance(selectedServer);
        if (selectedServer != null && settings != null) {
            this.currentDomain = settings;
            this.loginInput.setText(settings.getSettings("settings", "email"));
            this.timeZoneComboBox.setSelectedItem(this.currentDomain.getSettings("settings", "timezone"));
            this.urlInput.setText(this.currentDomain.getUrl());
            String statusBarValue = this.currentDomain.getSettings("settings", "status_bar_enabled");
            this.statusBar.setSelected(statusBarValue == null || !statusBarValue.trim().equalsIgnoreCase("false"));
            String debugValue = this.currentDomain.getSettings("settings", "debug");
            this.debug.setSelected(debugValue != null && debugValue.trim().equalsIgnoreCase("true"));
        }
    }

    private void updateDeleteButtonState() {
        this.deleteServerButton.setEnabled(this.serverComboBox.getItemCount() > 1);
    }

    private void openAddServerDialog() {
        this.addServerButton.setVisible(false);
        AddServerDialog addServerDialog = new AddServerDialog(this.project);
        addServerDialog.show();
        if (addServerDialog.isOK()) {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(ServerSettingsFactory.getAllDomains());
            this.serverComboBox.setModel(model);
            this.addServerButton.setVisible(true);
            this.updateDeleteButtonState();
        } else {
            this.addServerButton.setVisible(true);
        }
    }

    private void deleteSelectedServer() {
        String selectedServer = (String)this.serverComboBox.getSelectedItem();
        if (selectedServer != null) {
            try {
                ServerSettingsFactory.removeServer(selectedServer, AuthenticationType.LOGIN_PASSWORD);
                if (this.currentDomain.getDomain().equals(selectedServer)) {
                    for (Project openProject : ProjectManager.getInstanceIfCreated().getOpenProjects()) {
                        StatusBar projectStatusBar = WindowManager.getInstance().getStatusBar(openProject);
                        if (projectStatusBar == null) continue;
                        projectStatusBar.removeWidget(this.currentDomain.getDomain());
                    }
                    this.currentDomain = ServerSettingsFactory.getDefaultServerSettings();
                    this.serverComboBox.removeItem(selectedServer);
                    this.urlInput.setText(this.currentDomain.getUrl());
                    this.updateFieldsBasedOnSelectedServer();
                }
                PanDevMetrics.initStatusBar();
                this.updateDeleteButtonState();
            }
            catch (IOException e) {
                this.showErrorDialog(e.getMessage());
            }
        }
    }

    private void showErrorDialog(String errorMessage) {
        JOptionPane.showMessageDialog(this.userInfoFormPanel, errorMessage, "Error", 0);
    }
}

