/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import kz.pandev.plugins.metrics.PanDevMetrics;
import org.jetbrains.annotations.NotNull;

public class SettingsFileReadWriterUtil {
    private SettingsFileReadWriterUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(File configFile, String section, String key) {
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            String valuePart;
            block11: {
                String line;
                String currentSection = "";
                while ((line = br.readLine()) != null) {
                    int equalsIndex;
                    if (SettingsFileReadWriterUtil.isLineSettingsSection(line = line.trim())) {
                        currentSection = SettingsFileReadWriterUtil.extractSectionNameFromLine(line);
                        continue;
                    }
                    if (!SettingsFileReadWriterUtil.isCurrentSection(section, currentSection) || (equalsIndex = line.indexOf(61)) <= 0) continue;
                    String keyPart = line.substring(0, equalsIndex).trim();
                    valuePart = line.substring(equalsIndex + 1).trim();
                    if (!keyPart.equalsIgnoreCase(key)) {
                        continue;
                    }
                    break block11;
                }
                return null;
            }
            String string = SettingsFileReadWriterUtil.removeNulls(valuePart);
            return string;
        }
        catch (IOException e) {
            PanDevMetrics.log.error("Error when reading file: {}", (Object)configFile.getAbsoluteFile(), (Object)e);
        }
        return null;
    }

    public static void write(File configFilePath, String section, String key, String val) {
        key = SettingsFileReadWriterUtil.removeNulls(key);
        val = SettingsFileReadWriterUtil.removeNulls(val);
        StringBuilder contents = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(configFilePath));){
            String currentSection = "";
            String line = br.readLine();
            boolean found = false;
            while (line != null) {
                if (SettingsFileReadWriterUtil.isLineSettingsSection(line = SettingsFileReadWriterUtil.removeNulls(line).trim())) {
                    if (SettingsFileReadWriterUtil.isCurrentSection(section, currentSection) && !found) {
                        found = SettingsFileReadWriterUtil.addKeyValuePair(contents, key, val);
                    }
                    currentSection = SettingsFileReadWriterUtil.extractSectionNameFromLine(line);
                    SettingsFileReadWriterUtil.addLineAndReturnOfCarriage(contents, line);
                } else if (SettingsFileReadWriterUtil.isCurrentSection(section, currentSection)) {
                    found = SettingsFileReadWriterUtil.processLine(line, key, val, contents, found);
                } else {
                    SettingsFileReadWriterUtil.addLineAndReturnOfCarriage(contents, line);
                }
                line = br.readLine();
            }
            SettingsFileReadWriterUtil.createSectionIfNotFoundAndAddKeyValuePair(section, key, val, found, currentSection, contents);
        }
        catch (IOException e) {
            PanDevMetrics.log.error("File not found: {}", (Object)configFilePath.getAbsoluteFile(), (Object)e);
            contents = SettingsFileReadWriterUtil.createSectionAndAddKeyValuePair(section, key, val);
        }
        SettingsFileReadWriterUtil.writeToConfigFile(configFilePath, contents);
    }

    private static void createSectionIfNotFoundAndAddKeyValuePair(String section, String key, String val, boolean found, String currentSection, StringBuilder contents) {
        if (!found) {
            if (!SettingsFileReadWriterUtil.isCurrentSection(section, currentSection)) {
                SettingsFileReadWriterUtil.addSection(section, contents);
            }
            SettingsFileReadWriterUtil.addKeyValuePair(contents, key, val);
        }
    }

    @NotNull
    private static StringBuilder createSectionAndAddKeyValuePair(String section, String key, String val) {
        StringBuilder contents = new StringBuilder();
        SettingsFileReadWriterUtil.addSection(section, contents);
        SettingsFileReadWriterUtil.addKeyValuePair(contents, key, val);
        StringBuilder stringBuilder = contents;
        if (stringBuilder == null) {
            SettingsFileReadWriterUtil.$$$reportNull$$$0(0);
        }
        return stringBuilder;
    }

    @NotNull
    private static String extractSectionNameFromLine(String line) {
        String string = line.substring(1, line.length() - 1).toLowerCase();
        if (string == null) {
            SettingsFileReadWriterUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static boolean isLineSettingsSection(String line) {
        return line.startsWith("[") && line.endsWith("]");
    }

    private static boolean isCurrentSection(String section, String currentSection) {
        return section.toLowerCase().equals(currentSection);
    }

    private static void writeToConfigFile(File configFilePath, StringBuilder contents) {
        try (PrintWriter writer = new PrintWriter(configFilePath, StandardCharsets.UTF_8);){
            writer.print(contents);
        }
        catch (FileNotFoundException e) {
            PanDevMetrics.log.error("File not found:: {}", (Object)configFilePath.getAbsoluteFile(), (Object)e);
        }
        catch (IOException e) {
            PanDevMetrics.log.error("Error file unsupported encoding: {}", (Object)configFilePath.getAbsoluteFile(), (Object)e);
        }
    }

    private static boolean processLine(String line, String key, String val, StringBuilder contents, boolean found) {
        String[] parts = line.split("=");
        String currentKey = parts[0].trim();
        if (currentKey.equals(key)) {
            if (!found) {
                found = SettingsFileReadWriterUtil.addKeyValuePair(contents, key, val);
            }
        } else {
            SettingsFileReadWriterUtil.addLineAndReturnOfCarriage(contents, line);
        }
        return found;
    }

    private static void addLineAndReturnOfCarriage(StringBuilder contents, String line) {
        contents.append(line).append("\n");
    }

    private static void addSection(String section, StringBuilder contents) {
        contents.append("[").append(section.toLowerCase()).append("]\n");
    }

    private static boolean addKeyValuePair(StringBuilder contents, String key, String val) {
        SettingsFileReadWriterUtil.addLineAndReturnOfCarriage(contents.append(key).append(" = "), val);
        return true;
    }

    public static String removeNulls(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\u0000", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "kz/pandev/plugins/metrics/utils/SettingsFileReadWriterUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSectionAndAddKeyValuePair";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSectionNameFromLine";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

