/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.KeyboardFocusManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.swing.Icon;
import kz.pandev.plugins.metrics.actions.DatabaseActions;
import kz.pandev.plugins.metrics.clients.ApiClient;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.exception.ExceptionActionProcessor;
import kz.pandev.plugins.metrics.factory.ServerSettingsFactory;
import kz.pandev.plugins.metrics.listeners.BulkAwareDocumentListenerImpl;
import kz.pandev.plugins.metrics.listeners.CaretListenerImpl;
import kz.pandev.plugins.metrics.listeners.EditorMouseListenerImpl;
import kz.pandev.plugins.metrics.listeners.FileDocumentManagerListenerImpl;
import kz.pandev.plugins.metrics.listeners.VisibleAreaListenerImpl;
import kz.pandev.plugins.metrics.models.Heartbeat;
import kz.pandev.plugins.metrics.models.LineStatistics;
import kz.pandev.plugins.metrics.models.UserActivityByDateAndProjectDto;
import kz.pandev.plugins.metrics.ui_dialogs.LoginPage;
import kz.pandev.plugins.metrics.ui_dialogs.Settings;
import kz.pandev.plugins.metrics.utils.EncryptionUtil;
import kz.pandev.plugins.metrics.utils.GitInfoProvider;
import kz.pandev.plugins.metrics.utils.PluginUtils;
import kz.pandev.plugins.metrics.widgets.PanDevStatusbarWidget;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.http.HttpException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PanDevMetrics
implements ApplicationComponent {
    public static final BigDecimal FREQUENCY = new BigDecimal(120);
    public static final Logger log = LogManager.getLogger(PanDevMetrics.class);
    private static final Map<String, LineStatistics> lineStatisticsCache = new HashMap<String, LineStatistics>();
    public static String VERSION;
    public static String IDE_VERSION;
    private static MessageBusConnection connection;
    private static String lastFile;
    private static BigDecimal lastTime;
    private static final Boolean IS_BUILDING;
    private static boolean isLoginPageCanceled;
    private static boolean isSettingsWindowOpen;
    private static final ScheduledExecutorService scheduler;
    private static final Gson GSON;
    private static ScheduledFuture<?> scheduledFixture;
    public static boolean isVersionChecked;
    private static BigDecimal todayTextTime;

    public static Icon getLogoIcon() {
        String theme = JBColor.isBright() ? "light" : "dark";
        return IconLoader.getIcon((String)("images/icons/status-bar-icon-" + theme + "-theme.svg"), PanDevMetrics.class);
    }

    public void initComponent() {
        connection = ApplicationManager.getApplication().getMessageBus().connect();
        VERSION = Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"kz.pandev.intellij.plugin"))).getVersion();
        IDE_VERSION = ApplicationInfo.getInstance().getFullApplicationName();
        String message = "Initializing PanDev Metrics plugin v%s".formatted(VERSION);
        log.info(message);
        ServerSettingsFactory.initServers();
        PanDevMetrics.initStatusBar();
        this.initEventListeners();
        PanDevMetrics.initQueueProcessor();
        DatabaseActions.init();
        ExceptionActionProcessor.init();
    }

    public static void initStatusBar() {
        PanDevMetrics.updateStatusBarText();
    }

    private void initEventListeners() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Disposable disposable = Disposer.newDisposable((String)"PanDevMetricsListener");
            connection.subscribe(FileDocumentManagerListener.TOPIC, (Object)new FileDocumentManagerListenerImpl());
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new BulkAwareDocumentListenerImpl(), disposable);
            EditorFactory.getInstance().getEventMulticaster().addEditorMouseListener((EditorMouseListener)new EditorMouseListenerImpl(), disposable);
            EditorFactory.getInstance().getEventMulticaster().addVisibleAreaListener((VisibleAreaListener)new VisibleAreaListenerImpl(), disposable);
            EditorFactory.getInstance().getEventMulticaster().addCaretListener((CaretListener)new CaretListenerImpl(), disposable);
        });
    }

    private static void initQueueProcessor() {
        Runnable handler = PanDevMetrics::processHeartbeatQueue;
        long delay = 30L;
        scheduledFixture = scheduler.scheduleAtFixedRate(handler, delay, delay, TimeUnit.SECONDS);
    }

    public void disposeComponent() {
        try {
            connection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            scheduledFixture.cancel(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PanDevMetrics.processHeartbeatQueue();
    }

    public static void checkIsConfigured() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = PanDevMetrics.getCurrentProject();
            if (project == null) {
                return;
            }
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() || !app.isDispatchThread()) {
                return;
            }
            Collection<ServerSettings> allServerSettings = ServerSettingsFactory.getAllServerSettings();
            PanDevMetrics.validateServerSettingsAndShowAddServerDialogIfNotValid(allServerSettings, project);
        });
    }

    private static void validateServerSettingsAndShowAddServerDialogIfNotValid(Collection<ServerSettings> allServerSettings, Project project) {
        if (allServerSettings.isEmpty()) {
            if (isLoginPageCanceled || isSettingsWindowOpen) {
                return;
            }
            LoginPage loginPage = new LoginPage(project);
            loginPage.promptForEmail();
        } else {
            for (ServerSettings serverSettings : allServerSettings) {
                if (!serverSettings.isConfigured()) {
                    if (isLoginPageCanceled || isSettingsWindowOpen) continue;
                    try {
                        Settings settings = new Settings(project, serverSettings);
                        settings.show();
                    }
                    catch (Exception e) {
                        PanDevMetrics.warnException(e);
                    }
                    continue;
                }
                if (isVersionChecked) continue;
                isVersionChecked = true;
                log.info("Requested to get version from server");
                PluginUtils.checkForUpdates(serverSettings.getUrl());
            }
        }
    }

    public static BigDecimal getCurrentTimestamp() {
        return new BigDecimal(String.valueOf((double)System.currentTimeMillis() / 1000.0)).setScale(4, RoundingMode.HALF_UP);
    }

    public static void appendHeartbeat(VirtualFile file, Project project, boolean isWrite, @Nullable LineStatistics lineStatistics) {
        String gitPath;
        PanDevMetrics.updateStatusBarText();
        if (!PanDevMetrics.shouldLogFile(file)) {
            return;
        }
        BigDecimal time = PanDevMetrics.getCurrentTimestamp();
        if (!isWrite && file.getPath().equals(lastFile) && !PanDevMetrics.enoughTimePassed(time)) {
            return;
        }
        lastFile = file.getPath();
        lastTime = time;
        String moduleName = null;
        String moduleGitBranch = null;
        Module currentModule = PanDevMetrics.getCurrentModule(project, file);
        if (currentModule != null) {
            moduleName = currentModule.getName();
            moduleGitBranch = GitInfoProvider.getModuleGitBranch(currentModule);
        }
        String projectBasePath = project.getBasePath();
        String finalModuleName = moduleName != null ? moduleName : project.getName();
        String projectName = project.getName();
        String language = PanDevMetrics.getFileLanguage(file);
        String[] gitInfo = GitInfoProvider.getGitBranch(projectBasePath);
        String string = gitPath = gitInfo.length > 0 ? gitInfo[0] : null;
        String gitBranch = Objects.nonNull(moduleGitBranch) ? moduleGitBranch : (gitInfo.length > 1 ? gitInfo[1] : null);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Heartbeat h = new Heartbeat();
            h.setTimestamp(time);
            h.setProject(projectName);
            h.setModule(finalModuleName);
            h.setLanguage(language);
            h.setGitBranch(gitBranch);
            h.setGitPath(gitPath);
            h.setFileName(file.getName());
            h.setIde(IDE_VERSION);
            h.setLineCount(lineStatistics.getLineCount());
            h.setLineNumber(lineStatistics.getLineNumber());
            h.setCursorPosition(lineStatistics.getCursorPosition());
            for (ServerSettings serverSetting : ServerSettingsFactory.getAllServerSettings()) {
                serverSetting.getHeartbeatsQueue().add(h);
            }
            if (Boolean.TRUE.equals(IS_BUILDING)) {
                PanDevMetrics.setBuildTimeout();
            }
        });
    }

    private static void setBuildTimeout() {
        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
            if (Boolean.FALSE.equals(IS_BUILDING)) {
                return;
            }
            Project project = PanDevMetrics.getCurrentProject();
            if (project == null) {
                return;
            }
            if (PanDevMetrics.isProjectUninitialized(project)) {
                return;
            }
            VirtualFile file = PanDevMetrics.getCurrentVirtualFile(project);
            if (file == null) {
                return;
            }
            LineStatistics lineStatistics = PanDevMetrics.getLineStatistics(file);
            PanDevMetrics.appendHeartbeat(file, project, false, lineStatistics);
        }, 10L, TimeUnit.SECONDS);
    }

    private static void processHeartbeatQueue() {
        PanDevMetrics.checkIsConfigured();
        for (ServerSettings serverSetting : ServerSettingsFactory.getAllServerSettings()) {
            Heartbeat h;
            Heartbeat heartbeat = serverSetting.getHeartbeatsQueue().poll();
            if (heartbeat == null) {
                return;
            }
            ArrayList<Heartbeat> extraHeartbeats = new ArrayList<Heartbeat>();
            while ((h = serverSetting.getHeartbeatsQueue().poll()) != null) {
                extraHeartbeats.add(h);
            }
            PanDevMetrics.sendHeartbeat(serverSetting, heartbeat, extraHeartbeats);
        }
    }

    public static String heartBeatsToJSON(List<Heartbeat> extraHeartbeats) {
        return GSON.toJson(extraHeartbeats);
    }

    public static void addJsonObjectToFile(File file, List<Heartbeat> heartbeats) {
        if (file == null || heartbeats == null) {
            throw new IllegalArgumentException("File or heartbeat list is null");
        }
        try {
            List<Heartbeat> existingObjects = PanDevMetrics.readObjectsFromFile(file);
            existingObjects.addAll(heartbeats);
            PanDevMetrics.writeObjectsToFile(existingObjects, file);
        }
        catch (IOException e) {
            log.error("Failed to add JSON object to file: {}", (Object)file.getAbsoluteFile(), (Object)e);
        }
    }

    public static void sendHeartbeat(ServerSettings serverSettings, Heartbeat heartbeat, List<Heartbeat> extraHeartbeats) {
        if (!extraHeartbeats.isEmpty() && heartbeat != null) {
            extraHeartbeats.add(0, heartbeat);
        } else {
            extraHeartbeats.add(heartbeat);
        }
        if (serverSettings.getQueueFile(false).length() == 0L) {
            try {
                String encryptedJson = EncryptionUtil.encrypt(PanDevMetrics.heartBeatsToJSON(extraHeartbeats));
                ApiClient.sendJsonStringToServer(serverSettings, encryptedJson, "/v4/handler");
            }
            catch (IOException | InterruptedException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                PanDevMetrics.addJsonObjectToFile(serverSettings.getQueueFile(false), extraHeartbeats);
            }
        } else {
            try {
                PanDevMetrics.addHeartbeatsToQueueFileAndSendBatch(serverSettings, extraHeartbeats);
            }
            catch (IOException | InterruptedException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                PanDevMetrics.addJsonObjectToFile(serverSettings.getQueueFile(false), extraHeartbeats);
            }
        }
    }

    public static void addHeartbeatsToQueueFileAndSendBatch(ServerSettings serverSettings, List<Heartbeat> heartbeats) throws IOException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException, InterruptedException {
        List<Heartbeat> allHeartbeats = PanDevMetrics.readObjectsFromFile(serverSettings.getQueueFile(false));
        allHeartbeats.addAll(heartbeats);
        int batchSize = Math.min(50, allHeartbeats.size());
        List<Heartbeat> heartbeatsBatch = allHeartbeats.subList(0, batchSize);
        String encryptedJson = EncryptionUtil.encrypt(PanDevMetrics.heartBeatsToJSON(heartbeatsBatch));
        ApiClient.sendJsonStringToServer(serverSettings, encryptedJson, "/v4/handler");
        if (batchSize < 50) {
            PanDevMetrics.clearFile(serverSettings.getQueueFile(false));
        } else {
            allHeartbeats.removeAll(heartbeatsBatch);
            PanDevMetrics.writeObjectsToFile(allHeartbeats, serverSettings.getQueueFile(false));
        }
    }

    public static List<Heartbeat> readObjectsFromFile(File file) throws IOException {
        ArrayList<Heartbeat> existingObjects = new ArrayList<Heartbeat>();
        if (file.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                char[] buffer = new char[(int)file.length()];
                reader.read(buffer);
                String encryptedJson = new String(buffer);
                String decryptedJson = EncryptionUtil.decrypt(encryptedJson);
                Heartbeat[] objectsArray = (Heartbeat[])GSON.fromJson(decryptedJson, Heartbeat[].class);
                if (objectsArray != null) {
                    Collections.addAll(existingObjects, objectsArray);
                }
            }
            catch (Exception e) {
                throw new IOException("Error while decrypting data", e);
            }
        }
        return existingObjects;
    }

    public static void writeObjectsToFile(List<Heartbeat> heartbeats, File file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            String json = GSON.toJson(heartbeats);
            String encryptedJson = EncryptionUtil.encrypt(json);
            writer.write(encryptedJson);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Module getCurrentModule(Project project, VirtualFile virtualFile) {
        Module[] modules;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : modules = moduleManager.getModules()) {
            if (!ModuleRootManager.getInstance((Module)module).getFileIndex().isInContent(virtualFile)) continue;
            return module;
        }
        return null;
    }

    public static boolean enoughTimePassed(BigDecimal currentTime) {
        return lastTime.add(FREQUENCY).compareTo(currentTime) < 0;
    }

    public static boolean shouldLogFile(VirtualFile file) {
        if (file == null || file.getUrl().startsWith("mock://")) {
            return false;
        }
        String filePath = file.getPath();
        return !filePath.equals("atlassian-ide-plugin.xml") && !filePath.contains("/.idea/workspace.xml");
    }

    public static boolean isAppInactive() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() == null;
    }

    public static boolean isProjectUninitialized(Project project) {
        if (project == null) {
            return false;
        }
        return !project.isInitialized();
    }

    private static String getFileLanguage(VirtualFile file) {
        FileType type = file.getFileType();
        return type.getName();
    }

    @Nullable
    public static VirtualFile getVirtualFile(Document document) {
        if (document == null) {
            return null;
        }
        FileDocumentManager instance = FileDocumentManager.getInstance();
        return instance.getFile(document);
    }

    @Nullable
    public static VirtualFile getCurrentVirtualFile(Project project) {
        if (project == null) {
            return null;
        }
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        return PanDevMetrics.getVirtualFile(document);
    }

    public static Project getProject(Document document) {
        Editor[] editors = EditorFactory.getInstance().getEditors(document);
        if (editors.length > 0) {
            return editors[0].getProject();
        }
        return null;
    }

    @Nullable
    public static Project getCurrentProject() {
        Project project = null;
        try {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return project;
    }

    public static void openDashboardWebsite(String url) {
        BrowserUtil.browse((String)url);
    }

    public static void updateStatusBarText() {
        BigDecimal now = PanDevMetrics.getCurrentTimestamp();
        if (todayTextTime.add(new BigDecimal(60)).compareTo(now) > 0) {
            return;
        }
        todayTextTime = PanDevMetrics.getCurrentTimestamp();
        CompletableFuture.runAsync(PanDevMetrics::fetchTodayStats);
    }

    public static Map<String, PanDevStatusbarWidget.ModuleStatus.Status> fetchTodayStatusIcon(ServerSettings serverSettings, MultiValueMap modulesPaths) {
        if (serverSettings.isGitEnabled()) {
            try {
                return ApiClient.isProjectsBelongsToCompany(serverSettings, modulesPaths);
            }
            catch (IllegalArgumentException e) {
                log.error("Failed to fetch today status icon", (Throwable)e);
                return PanDevMetrics.buildStatusMap(modulesPaths, PanDevStatusbarWidget.ModuleStatus.Status.INACTIVE);
            }
            catch (IOException | InterruptedException | HttpException e) {
                log.error("Failed to fetch today status icon", e);
                return PanDevMetrics.buildStatusMap(modulesPaths, PanDevStatusbarWidget.ModuleStatus.Status.ISSUES);
            }
        }
        return PanDevMetrics.buildStatusMap(modulesPaths, PanDevStatusbarWidget.ModuleStatus.Status.ACTIVE);
    }

    public static void fetchTodayStats() {
        for (ServerSettings serverSettings : ServerSettingsFactory.getAllServerSettings()) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                log.debug("updating status bar for {}", (Object)project.getName());
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                statusBar.updateWidget(serverSettings.getDomain());
                statusBar.removeWidget("PanDevStatusbarWidget");
                PanDevStatusbarWidget widget = (PanDevStatusbarWidget)statusBar.getWidget(serverSettings.getDomain());
                if (widget != null) {
                    if (!serverSettings.isStatusBarEnabled()) {
                        statusBar.removeWidget(serverSettings.getDomain());
                        continue;
                    }
                    CompletableFuture.runAsync(() -> widget.refresh(serverSettings));
                    log.info("called refresh in PanDevMetrics for settings {}", (Object)serverSettings.getDomain());
                    continue;
                }
                if (!serverSettings.isStatusBarEnabled()) continue;
                PanDevStatusbarWidget newWidget = new PanDevStatusbarWidget(project, serverSettings.getDomain());
                statusBar.addWidget((StatusBarWidget)newWidget, (Disposable)project);
                CompletableFuture.runAsync(() -> newWidget.refresh(serverSettings));
                log.info("added widget for server {}", (Object)serverSettings.getDomain());
            }
        }
    }

    public static LineStatistics getLineStatistics(@Nullable Document document, @Nullable Editor editor) {
        Project project;
        if (editor == null && document != null && (project = PanDevMetrics.getProject(document)) != null && project.isInitialized()) {
            editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        }
        if (Objects.isNull(editor)) {
            return PanDevMetrics.getLineStatistics(document);
        }
        if (Objects.isNull(document)) {
            document = editor.getDocument();
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            LogicalPosition position = caret.getLogicalPosition();
            LineStatistics lineStatistics = new LineStatistics();
            lineStatistics.setLineCount(document.getLineCount());
            lineStatistics.setLineNumber(position.line + 1);
            lineStatistics.setCursorPosition(position.column + 1);
            if (!lineStatistics.isAllFieldsNotNull()) continue;
            PanDevMetrics.saveLineStatistics(document, lineStatistics);
            return lineStatistics;
        }
        return PanDevMetrics.getLineStatistics(document);
    }

    public static LineStatistics getLineStatistics(@Nullable Document document) {
        if (document != null) {
            LineStatistics lineStatistics = new LineStatistics();
            lineStatistics.setLineCount(document.getLineCount());
            Caret caret = (Caret)CommonDataKeys.CARET.getData(DataManager.getInstance().getDataContext());
            LogicalPosition position = caret.getLogicalPosition();
            lineStatistics.setLineNumber(position.line + 1);
            lineStatistics.setCursorPosition(position.column + 1);
            if (lineStatistics.isAllFieldsNotNull()) {
                PanDevMetrics.saveLineStatistics(document, lineStatistics);
                return lineStatistics;
            }
        }
        return PanDevMetrics.getLineStatistics(PanDevMetrics.getVirtualFile(document));
    }

    public static LineStatistics getLineStatistics(@Nullable VirtualFile file) {
        Caret caret = (Caret)CommonDataKeys.CARET.getData(DataManager.getInstance().getDataContext());
        if (caret == null) {
            return file == null ? new LineStatistics() : lineStatisticsCache.get(file.getPath());
        }
        LineStatistics lineStatistics = new LineStatistics();
        LogicalPosition position = caret.getLogicalPosition();
        lineStatistics.setLineNumber(position.line + 1);
        lineStatistics.setCursorPosition(position.column + 1);
        Editor editor = caret.getEditor();
        Document document = editor.getDocument();
        lineStatistics.setLineCount(document.getLineCount());
        if (lineStatistics.isAllFieldsNotNull()) {
            PanDevMetrics.saveLineStatistics(file, lineStatistics);
            return lineStatistics;
        }
        return file == null ? new LineStatistics() : lineStatisticsCache.get(file.getPath());
    }

    public static void saveLineStatistics(Document document, LineStatistics lineStatistics) {
        VirtualFile file = PanDevMetrics.getVirtualFile(document);
        PanDevMetrics.saveLineStatistics(file, lineStatistics);
    }

    public static void saveLineStatistics(@Nullable VirtualFile file, LineStatistics lineStatistics) {
        if (file == null) {
            return;
        }
        if (!lineStatistics.isAllFieldsNotNull()) {
            return;
        }
        lineStatisticsCache.put(file.getPath(), lineStatistics);
    }

    public static UserActivityByDateAndProjectDto fetchTodayModulesActivity(ServerSettings serverSettings, String ... moduleNames) {
        try {
            return ApiClient.fetchUserActivityByProjects(serverSettings, LocalDate.now(ZoneId.of(serverSettings.getServerZoneId())), moduleNames);
        }
        catch (IOException | InterruptedException e) {
            log.error("Failed to fetch today modules activity : message - {}, class - {}", (Object)e.getMessage(), (Object)e.getClass().getName());
            return null;
        }
    }

    public static void debugException(Exception e) {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String str = e.getMessage() + "\n" + sw;
        log.debug(str);
    }

    public static void warnException(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String str = e.getMessage() + "\n" + sw;
        log.warn(str);
    }

    public static void clearFile(File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write("");
        }
    }

    public static void setIsLoginPageCanceled(Boolean newValue) {
        isLoginPageCanceled = newValue;
    }

    public static void setIsSettingsWindowOpen(boolean isSettingsWindowOpen) {
        PanDevMetrics.isSettingsWindowOpen = isSettingsWindowOpen;
    }

    private static Map<String, PanDevStatusbarWidget.ModuleStatus.Status> buildStatusMap(MultiValueMap modulesPaths, PanDevStatusbarWidget.ModuleStatus.Status status) {
        HashMap<String, PanDevStatusbarWidget.ModuleStatus.Status> statusMap = new HashMap<String, PanDevStatusbarWidget.ModuleStatus.Status>();
        for (Object entry : modulesPaths.entrySet()) {
            Collection names = (Collection)((Map.Entry)entry).getValue();
            for (String name : names) {
                statusMap.put(name, status);
            }
        }
        return statusMap;
    }

    static {
        lastFile = null;
        lastTime = new BigDecimal(0);
        IS_BUILDING = false;
        isLoginPageCanceled = false;
        isSettingsWindowOpen = false;
        scheduler = Executors.newScheduledThreadPool(1);
        GSON = new GsonBuilder().setPrettyPrinting().create();
        isVersionChecked = false;
        todayTextTime = new BigDecimal(0);
    }
}

