/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.actions;

import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.clients.ApiClient;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.factory.ServerSettingsFactory;
import kz.pandev.plugins.metrics.models.events.DatasourceEvent;
import kz.pandev.plugins.metrics.utils.EncryptionUtil;
import kz.pandev.plugins.metrics.utils.JsonUtils;

public final class DatabaseActions {
    private static final int BATCH_SIZE = 50;

    private DatabaseActions() {
        throw new UnsupportedOperationException("DataBaseActions class cannot be instantiated! - UtilityClass");
    }

    public static void init() {
        DatabaseActions.initQueueProcessor();
    }

    private static void initQueueProcessor() {
        Runnable handler = DatabaseActions::processEvents;
        long delay = 90L;
        AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(handler, delay, delay, TimeUnit.SECONDS);
    }

    private static void processEvents() {
        for (ServerSettings serverSetting : ServerSettingsFactory.getAllServerSettings()) {
            Queue<DatasourceEvent> queue = serverSetting.getEventDbQueue();
            File serverDbQueueFile = serverSetting.getDbQueueFile(false);
            if (queue.isEmpty() && serverDbQueueFile.length() == 0L) {
                return;
            }
            try {
                DatabaseActions.processQueueEvents(queue, serverSetting);
                DatabaseActions.processFileQueueEvents(serverDbQueueFile, serverSetting);
            }
            catch (Exception e) {
                PanDevMetrics.log.error("Error processing datasource events: ", (Throwable)e);
            }
        }
    }

    private static void processQueueEvents(Queue<DatasourceEvent> queue, ServerSettings serverSetting) throws IOException {
        ArrayList<DatasourceEvent> collectedEvents = new ArrayList<DatasourceEvent>();
        try {
            while (!serverSetting.getEventDbQueue().isEmpty()) {
                DatasourceEvent event = queue.poll();
                collectedEvents.add(event);
            }
            if (!collectedEvents.isEmpty()) {
                ApiClient.sendEventsToServer(serverSetting, collectedEvents, "/v3/datasource");
            }
        }
        catch (Exception e) {
            DatabaseActions.addJsonObjectToFile(serverSetting.getDbQueueFile(false), collectedEvents);
            throw new IOException("Failed to process queue events: ", e);
        }
    }

    private static void processFileQueueEvents(File file, ServerSettings serverSetting) throws IOException {
        ArrayList<DatasourceEvent> collectedEvents = new ArrayList<DatasourceEvent>();
        try {
            collectedEvents.addAll(DatabaseActions.readObjectsFromFile(file));
            List<DatasourceEvent> batchEvents = collectedEvents.subList(0, Math.min(collectedEvents.size(), 50));
            if (!batchEvents.isEmpty()) {
                ApiClient.sendEventsToServer(serverSetting, batchEvents, "/v3/datasource");
                collectedEvents.removeAll(batchEvents);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to process file queue events: ", e);
        }
        finally {
            DatabaseActions.writeObjectsToFile(collectedEvents, file);
        }
    }

    public static List<DatasourceEvent> readObjectsFromFile(File file) throws IOException {
        ArrayList<DatasourceEvent> existingObjects = new ArrayList<DatasourceEvent>();
        if (file.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                char[] buffer = new char[(int)file.length()];
                reader.read(buffer);
                String encryptedJson = new String(buffer);
                String decryptedJson = EncryptionUtil.decrypt(encryptedJson);
                DatasourceEvent[] objectsArray = JsonUtils.fromJson(decryptedJson, DatasourceEvent[].class);
                if (objectsArray != null) {
                    Collections.addAll(existingObjects, objectsArray);
                }
            }
            catch (Exception e) {
                throw new IOException("Error while decrypting data", e);
            }
        }
        return existingObjects;
    }

    public static void writeObjectsToFile(List<DatasourceEvent> dEvents, File file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            String json = JsonUtils.toJson(dEvents);
            String encryptedJson = EncryptionUtil.encrypt(json);
            writer.write(encryptedJson);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void addJsonObjectToFile(File file, List<DatasourceEvent> events) {
        if (file == null || events == null) {
            throw new IllegalArgumentException("File or heartbeat list is null");
        }
        try {
            List<DatasourceEvent> existingObjects = DatabaseActions.readObjectsFromFile(file);
            existingObjects.addAll(events);
            DatabaseActions.writeObjectsToFile(existingObjects, file);
        }
        catch (IOException e) {
            PanDevMetrics.log.error("Error while adding object to file", (Throwable)e);
        }
    }
}

