/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.exception;

import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.clients.ApiClient;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.exception.ExceptionFileActionManager;
import kz.pandev.plugins.metrics.factory.ServerSettingsFactory;
import kz.pandev.plugins.metrics.models.UnhandledPluginExceptionDto;
import kz.pandev.plugins.metrics.utils.EncryptionUtil;
import kz.pandev.plugins.metrics.utils.JsonUtils;

public class ExceptionActionProcessor {
    private static final AtomicReference<List<UnhandledPluginExceptionDto>> errorMapRef = new AtomicReference(new CopyOnWriteArrayList());

    private ExceptionActionProcessor() {
        throw new UnsupportedOperationException("ExceptionActions class cannot be instantiated! - UtilityClass");
    }

    public static void init() {
        ExceptionActionProcessor.initQueueProcessor();
    }

    public static void initQueueProcessor() {
        Runnable handler = ExceptionActionProcessor::sendAndClearErrors;
        long delay = 120L;
        AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(handler, delay, delay, TimeUnit.SECONDS);
    }

    public static void addError(UnhandledPluginExceptionDto object) {
        errorMapRef.get().add(object);
    }

    public static void sendAndClearErrors() {
        List listToSend = errorMapRef.getAndSet(new CopyOnWriteArrayList());
        for (ServerSettings serverSetting : ServerSettingsFactory.getAllServerSettings()) {
            try {
                if (serverSetting.getExceptionQueueFile(false).length() == 0L && ExceptionActionProcessor.isListNotEmpty(listToSend)) {
                    ExceptionActionProcessor.sendException(serverSetting, listToSend, " /error-handling");
                    continue;
                }
                if (serverSetting.getExceptionQueueFile(false).length() == 0L) continue;
                ExceptionActionProcessor.addPluginExceptionDTOsToQueueFileAndSendBatch(serverSetting, listToSend);
            }
            catch (Exception e) {
                ExceptionFileActionManager.addJsonObjectToFile(serverSetting.getExceptionQueueFile(false), listToSend);
            }
        }
    }

    public static void addPluginExceptionDTOsToQueueFileAndSendBatch(ServerSettings serverSetting, List<UnhandledPluginExceptionDto> listToSend) throws IOException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException, InterruptedException {
        List<UnhandledPluginExceptionDto> allPluginExceptionDTOs = ExceptionFileActionManager.readObjectsFromFile(serverSetting.getExceptionQueueFile(false));
        allPluginExceptionDTOs.addAll(listToSend);
        int batchSize = Math.min(20, allPluginExceptionDTOs.size());
        List<UnhandledPluginExceptionDto> pluginExceptionDTOsBatch = allPluginExceptionDTOs.subList(0, batchSize);
        ExceptionActionProcessor.sendException(serverSetting, pluginExceptionDTOsBatch, "/error-handling/from-queue");
        if (batchSize < 20) {
            PanDevMetrics.clearFile(serverSetting.getExceptionQueueFile(false));
        } else {
            allPluginExceptionDTOs.removeAll(pluginExceptionDTOsBatch);
            ExceptionFileActionManager.writeObjectsToFile(allPluginExceptionDTOs, serverSetting.getExceptionQueueFile(false));
        }
    }

    public static void sendException(ServerSettings serverSetting, List<UnhandledPluginExceptionDto> listToSend, String apiPath) throws NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException, IOException, InterruptedException {
        String json = JsonUtils.toJson(listToSend);
        String encryptedJson = EncryptionUtil.encrypt(json);
        ApiClient.sendJsonStringToServer(serverSetting, encryptedJson, apiPath);
    }

    private static boolean isListNotEmpty(List<UnhandledPluginExceptionDto> list) {
        return list != null && !list.isEmpty();
    }
}

