/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.exception;

import java.util.ArrayList;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.models.CauseExceptionDto;
import kz.pandev.plugins.metrics.models.UnhandledPluginExceptionDto;

public class ExceptionFactory {
    private ExceptionFactory() {
        throw new UnsupportedOperationException("ExceptionService class cannot be instantiated! - UtilityClass");
    }

    public static UnhandledPluginExceptionDto createUnhandledException(Throwable throwable, boolean fromErrorMode) {
        UnhandledPluginExceptionDto unhandledPluginExceptionDto = ExceptionFactory.createUnhandledPluginExceptionDTO(throwable);
        unhandledPluginExceptionDto.setIntellijErrorReport(fromErrorMode);
        if (throwable.getCause() != null) {
            CauseExceptionDto[] causeExceptionDTOs = ExceptionFactory.getCausesChain(throwable);
            unhandledPluginExceptionDto.setCauses(causeExceptionDTOs);
        }
        return unhandledPluginExceptionDto;
    }

    public static CauseExceptionDto[] getCausesChain(Throwable e) {
        ArrayList<CauseExceptionDto> causes = new ArrayList<CauseExceptionDto>();
        while (e.getCause() != null) {
            Throwable cause = e.getCause();
            CauseExceptionDto dtoObject = ExceptionFactory.createCauseExceptionDto(cause);
            causes.add(dtoObject);
            e = cause;
        }
        CauseExceptionDto[] result = new CauseExceptionDto[causes.size()];
        return causes.toArray(result);
    }

    private static UnhandledPluginExceptionDto createUnhandledPluginExceptionDTO(Throwable e) {
        UnhandledPluginExceptionDto unhandledPluginExceptionDto = new UnhandledPluginExceptionDto();
        unhandledPluginExceptionDto.setExceptionClassName(e.getClass().getName());
        unhandledPluginExceptionDto.setMessage(e.getMessage() == null || e.getMessage().isEmpty() ? "The message is missing" : e.getMessage());
        unhandledPluginExceptionDto.setStackTrace(e.getStackTrace() == null || e.getStackTrace().length == 0 ? ExceptionFactory.getDefaultStackTrace() : e.getStackTrace());
        unhandledPluginExceptionDto.setFullIDEName(PanDevMetrics.IDE_VERSION);
        unhandledPluginExceptionDto.setUserOS(ExceptionFactory.getUserOs());
        unhandledPluginExceptionDto.setLastTimestamp(PanDevMetrics.getCurrentTimestamp());
        return unhandledPluginExceptionDto;
    }

    private static CauseExceptionDto createCauseExceptionDto(Throwable e) {
        CauseExceptionDto causeExceptionDto = new CauseExceptionDto();
        causeExceptionDto.setExceptionClassName(e.getClass().getName());
        causeExceptionDto.setMessage(e.getMessage() == null || e.getMessage().isEmpty() ? "The message is missing" : e.getMessage());
        causeExceptionDto.setStackTrace(e.getStackTrace() == null || e.getStackTrace().length == 0 ? ExceptionFactory.getDefaultStackTrace() : e.getStackTrace());
        return causeExceptionDto;
    }

    private static StackTraceElement[] getDefaultStackTrace() {
        StackTraceElement s = new StackTraceElement("UnknownClass", "unknownMethod", "UnknownFile", 0);
        StackTraceElement[] str = new StackTraceElement[]{s};
        return str;
    }

    private static String getUserOs() {
        try {
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            return "OS Name: " + osName + ", Version: " + osVersion;
        }
        catch (SecurityException e) {
            return "Unknown OS";
        }
    }
}

