/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.factory;

import com.intellij.database.console.session.DatabaseSessionStateListener;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.factory.ServerSettingsFactory;
import kz.pandev.plugins.metrics.models.enums.DatasourceEventType;
import kz.pandev.plugins.metrics.models.events.DBManualCellChange;
import kz.pandev.plugins.metrics.models.events.DatasourceEvent;
import kz.pandev.plugins.metrics.utils.DataBaseUtils;
import org.jetbrains.annotations.NotNull;

public class DatasourceEventsFactory {
    private static final String CONSOLE = "console";

    private DatasourceEventsFactory() {
        throw new IllegalStateException("DatasourceEventsFactory cannot be instantiated!");
    }

    public static void pushConsoleDatabaseQueryEvent(@NotNull DatabaseSessionStateListener.ChangeEvent changeEvent) {
        if (changeEvent == null) {
            DatasourceEventsFactory.$$$reportNull$$$0(0);
        }
        for (ServerSettings settings : ServerSettingsFactory.getAllServerSettings()) {
            DatasourceEvent event = DatasourceEventsFactory.getInstance(changeEvent);
            if (event.getDatabaseScript() == null) continue;
            settings.getEventDbQueue().add(event);
        }
    }

    public static void pushSuccessConnectionEvent(DatabaseConnection connection, boolean b) {
        if (b) {
            for (ServerSettings settings : ServerSettingsFactory.getAllServerSettings()) {
                DatasourceEvent event = DatasourceEventsFactory.getInstance(connection.getConnectionPoint(), DatasourceEventType.CONNECTION_SUCCESSFUL, null);
                settings.getEventDbQueue().add(event);
            }
        }
    }

    public static void pushFailedConnectionEvent(DatabaseConnectionPoint connectionPoint, String errorMessage) {
        for (ServerSettings settings : ServerSettingsFactory.getAllServerSettings()) {
            DatasourceEvent event = DatasourceEventsFactory.getInstance(connectionPoint, DatasourceEventType.CONNECTION_FAILED, errorMessage);
            settings.getEventDbQueue().add(event);
        }
    }

    public static void pushUpdateDbColumnEvent(DataGrid dataGrid) {
        DatasourceEvent event = DatasourceEventsFactory.getInstance(dataGrid);
        if (event != null) {
            for (ServerSettings settings : ServerSettingsFactory.getAllServerSettings()) {
                settings.getEventDbQueue().add(event);
            }
        }
    }

    private static DBManualCellChange getDbColumnUpdateEvent(DataGrid dataGrid) {
        try {
            DBManualCellChange columnUpdate = new DBManualCellChange();
            ModelIndex selectionColumn = dataGrid.getSelectionModel().getSelectedColumn();
            GridColumn oldColumnName = (GridColumn)dataGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(selectionColumn);
            GridColumn newColumnName = (GridColumn)dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(selectionColumn);
            ModelIndex row = dataGrid.getSelectionModel().getSelectedRow();
            GridRow newColumn = (GridRow)dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRow(row);
            GridRow oldColumn = (GridRow)dataGrid.getDataModel(DataAccessType.DATABASE_DATA).getRow(row);
            if (newColumn == null || newColumnName == null || oldColumn == null || oldColumnName == null) {
                return null;
            }
            columnUpdate.setRecordId(String.valueOf(newColumn.getValue(0)));
            columnUpdate.setColumnName(newColumnName.getName());
            columnUpdate.setNewCellValue(String.valueOf(Objects.requireNonNull(newColumn).getValue(newColumnName.getColumnNumber())));
            columnUpdate.setOldCellValue(String.valueOf(Objects.requireNonNull(oldColumn).getValue(oldColumnName.getColumnNumber())));
            columnUpdate.setTable(DataBaseUtils.getTableName(dataGrid));
            if (columnUpdate.getOldCellValue().equals(columnUpdate.getNewCellValue())) {
                return null;
            }
            return columnUpdate;
        }
        catch (Exception e) {
            PanDevMetrics.log.error("Failed to create DatasourceEvent instance", (Throwable)e);
            return null;
        }
    }

    private static DatasourceEvent getInstance(DataGrid dataGrid) {
        DatabaseConnection connection = DataBaseUtils.getActiveConnection(dataGrid);
        DatasourceEvent event = DatasourceEventsFactory.getInstance(connection.getConnectionPoint(), DatasourceEventType.DB_CELL_MANUAL_CHANGE, null);
        DBManualCellChange dbManualCellChange = DatasourceEventsFactory.getDbColumnUpdateEvent(dataGrid);
        if (dbManualCellChange == null) {
            return null;
        }
        event.setDbColumnUpdate(dbManualCellChange);
        return event;
    }

    private static DatasourceEvent getInstance(@NotNull DatabaseSessionStateListener.ChangeEvent changeEvent) {
        if (changeEvent == null) {
            DatasourceEventsFactory.$$$reportNull$$$0(1);
        }
        DatabaseConnectionPoint connectionPoint = changeEvent.getSession().getConnectionPoint();
        DatasourceEvent event = DatasourceEventsFactory.getInstance(connectionPoint, DatasourceEventType.CONSOLE_QUERY, null);
        String title = changeEvent.getSession().getTitle();
        if (title.startsWith(CONSOLE)) {
            for (VirtualFile file : FileEditorManager.getInstance((Project)changeEvent.getSession().getProject()).getSelectedFiles()) {
                Document doc;
                String fileTitle = file.getName().split("\\.")[0];
                if (!fileTitle.equals(title) || (doc = FileDocumentManager.getInstance().getDocument(file)) == null) continue;
                String databaseScript = doc.getText();
                event.setDatabaseScript(databaseScript);
                break;
            }
        }
        return event;
    }

    private static DatasourceEvent getInstance(DatabaseConnectionPoint connectionPoint, DatasourceEventType eventType, String message) {
        DatasourceEvent event = new DatasourceEvent();
        event.setDatasourceTitle(connectionPoint.getName());
        event.setDatabase(connectionPoint.getDatabaseDriver().getName());
        event.setHost(connectionPoint.getUrl());
        event.setDatasourceUsername(connectionPoint.getDataSource().getUsername());
        event.setDriverVersion(connectionPoint.getDataSource().getDriverVersion().version);
        event.setEventType(eventType);
        event.setTimestamp(PanDevMetrics.getCurrentTimestamp());
        event.setMessage(message);
        return event;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "changeEvent";
        objectArray2[1] = "kz/pandev/plugins/metrics/factory/DatasourceEventsFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "pushConsoleDatabaseQueryEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

