/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.listeners;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.models.LineStatistics;

public class CaretListenerImpl
implements CaretListener {
    public void caretPositionChanged(CaretEvent event) {
        try {
            if (PanDevMetrics.isAppInactive()) {
                return;
            }
            Editor editor = event.getEditor();
            Document document = editor.getDocument();
            VirtualFile file = PanDevMetrics.getVirtualFile(document);
            if (file == null) {
                return;
            }
            Project project = editor.getProject();
            if (PanDevMetrics.isProjectUninitialized(project)) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                LineStatistics lineStatistics = PanDevMetrics.getLineStatistics(document, editor);
                PanDevMetrics.appendHeartbeat(file, project, false, lineStatistics);
            });
        }
        catch (Exception e) {
            PanDevMetrics.debugException(e);
        }
    }
}

