/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.report;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.IdeaReportingEvent;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.Consumer;
import java.awt.Component;
import kz.pandev.plugins.metrics.exception.ExceptionActionProcessor;
import kz.pandev.plugins.metrics.exception.ExceptionFactory;
import kz.pandev.plugins.metrics.models.UnhandledPluginExceptionDto;
import kz.pandev.plugins.metrics.utils.IntelliJBundleUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PanDevErrorReportSubmitter
extends ErrorReportSubmitter {
    @NlsActions.ActionText
    @NotNull
    public String getReportActionText() {
        String string = IntelliJBundleUtils.message("report.error.to.plugin.vendor", new Object[0]);
        if (string == null) {
            PanDevErrorReportSubmitter.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean submit(final IdeaLoggingEvent @NotNull [] events, @Nullable String additionalInfo, final @NotNull Component parentComponent, final @NotNull Consumer<? super SubmittedReportInfo> consumer) {
        if (parentComponent == null) {
            PanDevErrorReportSubmitter.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            PanDevErrorReportSubmitter.$$$reportNull$$$0(2);
        }
        if (events == null) {
            PanDevErrorReportSubmitter.$$$reportNull$$$0(3);
        }
        DataContext context = DataManager.getInstance().getDataContext(parentComponent);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        new Task.Backgroundable(project, "Sending error report"){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (IdeaLoggingEvent event : events) {
                    Throwable ex;
                    if (!(event instanceof IdeaReportingEvent) || !(event.getData() instanceof AbstractMessage) || !PanDevErrorReportSubmitter.this.filter(ex = ((AbstractMessage)event.getData()).getThrowable())) continue;
                    UnhandledPluginExceptionDto unhandledPluginExceptionDto = ExceptionFactory.createUnhandledException(ex, true);
                    ExceptionActionProcessor.addError(unhandledPluginExceptionDto);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    Messages.showInfoMessage((Component)parentComponent, (String)"Thank you for sending the report! Your feedback helps us improve our services.", (String)"PanDev Metrics: error report sent");
                    consumer.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.NEW_ISSUE));
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "kz/pandev/plugins/metrics/report/PanDevErrorReportSubmitter$1", "run"));
            }
        }.queue();
        return true;
    }

    private boolean filter(Throwable ex) {
        if (this.classnameFilter(ex.getStackTrace())) {
            return true;
        }
        while (ex.getCause() != null) {
            Throwable cause = ex.getCause();
            if (this.classnameFilter(cause.getStackTrace())) {
                return true;
            }
            ex = cause;
        }
        return false;
    }

    private boolean classnameFilter(StackTraceElement[] str) {
        for (StackTraceElement stackTraceElement : str) {
            if (!stackTraceElement.getClassName().startsWith("kz.pandev.plugins.metrics")) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kz/pandev/plugins/metrics/report/PanDevErrorReportSubmitter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReportActionText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "kz/pandev/plugins/metrics/report/PanDevErrorReportSubmitter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

