/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.utils;

import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.openapi.project.Project;

public class DataBaseUtils {
    private DataBaseUtils() {
        throw new IllegalStateException("Utility class cannot be instantiated " + this.getClass().getSimpleName());
    }

    public static String getConnectionTitle(DataGrid dataGrid) {
        String title = dataGrid.getDisplayName();
        return title.substring(title.indexOf("[") + 1, title.lastIndexOf("]"));
    }

    public static String getTableName(DataGrid dataGrid) {
        String title = dataGrid.getDisplayName();
        return title.substring(title.indexOf(":") + 1, title.lastIndexOf(" "));
    }

    public static DatabaseConnection getActiveConnection(DataGrid dataGrid) {
        String connectionTitle = DataBaseUtils.getConnectionTitle(dataGrid);
        for (DatabaseConnection connection : DatabaseConnectionManager.getInstance().getActiveConnections()) {
            String title = connection.getConnectionPoint().getName();
            if (!title.equals(connectionTitle)) continue;
            return connection;
        }
        throw new IllegalArgumentException("No active connection found!");
    }

    public static DatabaseSession getActiveSession(DataGrid dataGrid) {
        DatabaseConnection connection = DataBaseUtils.getActiveConnection(dataGrid);
        return DatabaseSessionManager.getSession((Project)dataGrid.getProject(), (DatabaseConnectionPoint)connection.getConnectionPoint());
    }
}

