/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.utils;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class MACAddressUtil {
    private MACAddressUtil() {
    }

    public static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                byte[] mac;
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (!MACAddressUtil.isValidNetworkInterface(networkInterface) || (mac = networkInterface.getHardwareAddress()) == null) continue;
                return MACAddressUtil.formatMacAddress(mac);
            }
        }
        catch (SocketException e) {
            return "Error Retrieving MAC address";
        }
        return "MAC address unknown";
    }

    private static boolean isValidNetworkInterface(NetworkInterface networkInterface) {
        try {
            return networkInterface.isUp() && !networkInterface.isLoopback() && !networkInterface.isVirtual();
        }
        catch (SocketException e) {
            return false;
        }
    }

    private static String formatMacAddress(byte[] mac) {
        StringBuilder macAddress = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            macAddress.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
        }
        return macAddress.toString();
    }
}

