/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kz.pandev.plugins.metrics.PanDevMetrics;
import org.jetbrains.annotations.NotNull;

public class SettingsFileReadWriterUtil {
    private SettingsFileReadWriterUtil() {
    }

    public static String read(File configFile, String section, String key) {
        List<String> lines;
        try {
            lines = Files.readAllLines(configFile.toPath());
        }
        catch (IOException e) {
            PanDevMetrics.log.error("Error when reading file: {}", (Object)configFile.getAbsoluteFile(), (Object)e);
            return null;
        }
        String currentSection = "";
        for (String line : lines) {
            int equalsIndex;
            if (SettingsFileReadWriterUtil.isLineSettingsSection(line = line.trim())) {
                currentSection = SettingsFileReadWriterUtil.extractSectionNameFromLine(line);
                continue;
            }
            if (!SettingsFileReadWriterUtil.isCurrentSection(section, currentSection) || (equalsIndex = line.indexOf(61)) <= 0) continue;
            String keyPart = line.substring(0, equalsIndex).trim();
            String valuePart = line.substring(equalsIndex + 1).trim();
            if (!keyPart.equalsIgnoreCase(key)) continue;
            return SettingsFileReadWriterUtil.removeNulls(valuePart);
        }
        return null;
    }

    public static Map<String, String> readAll(File configFile, String section) {
        List<String> lines;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            lines = Files.readAllLines(configFile.toPath());
        }
        catch (IOException e) {
            PanDevMetrics.log.error("Error when reading file: {}", (Object)configFile.getAbsoluteFile(), (Object)e);
            return result;
        }
        String currentSection = "";
        for (String line : lines) {
            int equalsIndex;
            if (SettingsFileReadWriterUtil.isLineSettingsSection(line = line.trim())) {
                currentSection = SettingsFileReadWriterUtil.extractSectionNameFromLine(line);
                continue;
            }
            if (!SettingsFileReadWriterUtil.isCurrentSection(section, currentSection) || (equalsIndex = line.indexOf(61)) <= 0) continue;
            String key = line.substring(0, equalsIndex).trim();
            String value = line.substring(equalsIndex + 1).trim();
            result.put(key, value);
        }
        return result;
    }

    public static void writeAll(File configFile, String section, Map<String, String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        try {
            StringBuilder content = new StringBuilder();
            content.append("[").append(section).append("]\n");
            for (Map.Entry<String, String> entry : values.entrySet()) {
                content.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
            }
            Files.writeString(configFile.toPath(), (CharSequence)content.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            PanDevMetrics.log.error("Failed to write config: {}", (Object)configFile.getAbsolutePath(), (Object)e);
        }
    }

    public static void write(File configFile, String section, String key, String value) {
        List<String> lines;
        key = SettingsFileReadWriterUtil.removeNulls(key);
        value = SettingsFileReadWriterUtil.removeNulls(value);
        try {
            lines = Files.readAllLines(configFile.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            PanDevMetrics.log.error("File not found: {}", (Object)configFile.getAbsoluteFile(), (Object)e);
            SettingsFileReadWriterUtil.writeToConfigFile(configFile, SettingsFileReadWriterUtil.createSectionAndAddKeyValuePair(section, key, value));
            return;
        }
        StringBuilder contents = new StringBuilder();
        String currentSection = "";
        boolean found = false;
        for (String line : lines) {
            if (SettingsFileReadWriterUtil.isLineSettingsSection(line = SettingsFileReadWriterUtil.removeNulls(line).trim())) {
                if (SettingsFileReadWriterUtil.isCurrentSection(section, currentSection) && !found) {
                    found = SettingsFileReadWriterUtil.addKeyValuePair(contents, key, value);
                }
                currentSection = SettingsFileReadWriterUtil.extractSectionNameFromLine(line);
                SettingsFileReadWriterUtil.addLineAndReturnOfCarriage(contents, line);
                continue;
            }
            if (SettingsFileReadWriterUtil.isCurrentSection(section, currentSection)) {
                found = SettingsFileReadWriterUtil.processLine(line, key, value, contents, found);
                continue;
            }
            SettingsFileReadWriterUtil.addLineAndReturnOfCarriage(contents, line);
        }
        SettingsFileReadWriterUtil.createSectionIfNotFoundAndAddKeyValuePair(section, key, value, found, currentSection, contents);
        SettingsFileReadWriterUtil.writeToConfigFile(configFile, contents);
    }

    private static void writeToConfigFile(File configFile, StringBuilder contents) {
        try (PrintWriter writer = new PrintWriter(configFile, StandardCharsets.UTF_8);){
            writer.print(contents);
        }
        catch (FileNotFoundException e) {
            PanDevMetrics.log.error("File not found:: {}", (Object)configFile.getAbsoluteFile(), (Object)e);
        }
        catch (IOException e) {
            PanDevMetrics.log.error("Error file unsupported encoding: {}", (Object)configFile.getAbsoluteFile(), (Object)e);
        }
    }

    private static void createSectionIfNotFoundAndAddKeyValuePair(String section, String key, String value, boolean found, String currentSection, StringBuilder contents) {
        if (!found) {
            if (!SettingsFileReadWriterUtil.isCurrentSection(section, currentSection)) {
                SettingsFileReadWriterUtil.addSection(section, contents);
            }
            SettingsFileReadWriterUtil.addKeyValuePair(contents, key, value);
        }
    }

    @NotNull
    private static StringBuilder createSectionAndAddKeyValuePair(String section, String key, String value) {
        StringBuilder contents = new StringBuilder();
        SettingsFileReadWriterUtil.addSection(section, contents);
        SettingsFileReadWriterUtil.addKeyValuePair(contents, key, value);
        StringBuilder stringBuilder = contents;
        if (stringBuilder == null) {
            SettingsFileReadWriterUtil.$$$reportNull$$$0(0);
        }
        return stringBuilder;
    }

    @NotNull
    private static String extractSectionNameFromLine(String line) {
        String string = line.substring(1, line.length() - 1).toLowerCase();
        if (string == null) {
            SettingsFileReadWriterUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static boolean isLineSettingsSection(String line) {
        return line.startsWith("[") && line.endsWith("]");
    }

    private static boolean isCurrentSection(String section, String currentSection) {
        return section.toLowerCase().equals(currentSection);
    }

    private static boolean processLine(String line, String key, String value, StringBuilder contents, boolean found) {
        String[] parts = line.split("=");
        String currentKey = parts[0].trim();
        if (currentKey.equals(key)) {
            if (!found) {
                found = SettingsFileReadWriterUtil.addKeyValuePair(contents, key, value);
            }
        } else {
            SettingsFileReadWriterUtil.addLineAndReturnOfCarriage(contents, line);
        }
        return found;
    }

    private static void addLineAndReturnOfCarriage(StringBuilder contents, String line) {
        contents.append(line).append("\n");
    }

    private static void addSection(String section, StringBuilder contents) {
        contents.append("[").append(section.toLowerCase()).append("]\n");
    }

    private static boolean addKeyValuePair(StringBuilder contents, String key, String value) {
        SettingsFileReadWriterUtil.addLineAndReturnOfCarriage(contents.append(key).append(" = "), value);
        return true;
    }

    public static String removeNulls(String line) {
        if (line == null) {
            return null;
        }
        return line.replace("\u0000", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "kz/pandev/plugins/metrics/utils/SettingsFileReadWriterUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSectionAndAddKeyValuePair";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSectionNameFromLine";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

