/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.clients;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.models.PluginVersionInfoDto;
import kz.pandev.plugins.metrics.models.ProjectOwnershipStatus;
import kz.pandev.plugins.metrics.models.ProjectOwnershipStatusResponseDto;
import kz.pandev.plugins.metrics.models.ServerSettingsDto;
import kz.pandev.plugins.metrics.models.SignInRequest;
import kz.pandev.plugins.metrics.models.UserActivityByDateAndProjectDto;
import kz.pandev.plugins.metrics.models.UserQuickDateDto;
import kz.pandev.plugins.metrics.models.events.DatasourceEvent;
import kz.pandev.plugins.metrics.utils.EncryptionUtil;
import kz.pandev.plugins.metrics.utils.IPAddressUtil;
import kz.pandev.plugins.metrics.utils.JsonUtils;
import kz.pandev.plugins.metrics.utils.MACAddressUtil;
import kz.pandev.plugins.metrics.utils.PluginUtils;
import kz.pandev.plugins.metrics.widgets.PanDevStatusbarWidget;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.http.HttpException;
import org.jetbrains.annotations.NotNull;

public class ApiClient {
    static HttpClient httpClient = HttpClient.newHttpClient();
    private static final String APPLICATION_CONTENT_TYPE = "application/json";
    private static final String EXCEPTION_MESSAGE = "The server responded with an error code: ";

    private ApiClient() {
    }

    public static void sendEventsToServer(ServerSettings serverSettings, List<DatasourceEvent> events, String apiPath) throws IOException, InterruptedException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        String json = JsonUtils.toJson(events);
        String encryptedJson = EncryptionUtil.encrypt(json);
        String url = serverSettings.getUrl();
        String headerValue = serverSettings.getAuthenticationHeader();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url + apiPath)).header("Content-Type", APPLICATION_CONTENT_TYPE).header("Authorization", headerValue).POST(HttpRequest.BodyPublishers.ofString(encryptedJson)).timeout(Duration.of(30L, ChronoUnit.SECONDS)).build();
        ApiClient.sendRequest(request);
    }

    public static void sendJsonStringToServer(ServerSettings serverSettings, String json, String apiPath) throws IOException, InterruptedException {
        ApiClient.sendJsonStringToServer(serverSettings, json, apiPath, new HashMap<String, String>());
    }

    public static void sendJsonStringToServer(ServerSettings serverSettings, String json, String apiPath, Map<String, String> params) throws IOException, InterruptedException {
        String url = serverSettings.getUrl();
        String headerValue = serverSettings.getAuthenticationHeader();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url + apiPath + ApiClient.parseParams(params))).header("Content-Type", APPLICATION_CONTENT_TYPE).header("Authorization", headerValue).POST(HttpRequest.BodyPublishers.ofString(json)).timeout(Duration.of(30L, ChronoUnit.SECONDS)).build();
        ApiClient.sendRequest(request);
    }

    public static HttpResponse<String> getToken(String email, String password, String url, String timezone) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url + "/v1/auth/sign-in")).header("Content-Type", APPLICATION_CONTENT_TYPE).POST(HttpRequest.BodyPublishers.ofString(ApiClient.getUserDataAsJson(email, password, timezone))).timeout(Duration.of(10L, ChronoUnit.SECONDS)).build();
        try {
            return httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            PanDevMetrics.log.error(e.getMessage());
            return null;
        }
    }

    static HttpResponse<String> sendRequest(HttpRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response == null || response.statusCode() != 200) {
            PanDevMetrics.log.error("Request failed to url {}", (Object)request.uri());
            throw new IOException();
        }
        return response;
    }

    private static HttpResponse<String> sendGetRequest(String url, ServerSettings serverSettings) throws IOException, InterruptedException {
        String authenticationHeader = serverSettings.getAuthenticationHeader();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", APPLICATION_CONTENT_TYPE).header("Authorization", authenticationHeader).GET().timeout(Duration.of(5L, ChronoUnit.SECONDS)).build();
        return ApiClient.sendRequest(request);
    }

    private static String getUserDataAsJson(String email, String password, String timezone) {
        SignInRequest signInRequest = new SignInRequest();
        signInRequest.setUsername(email);
        signInRequest.setPassword(password);
        signInRequest.setUserTimeZone(timezone);
        signInRequest.setSystemTimeZone(TimeZone.getDefault().getID());
        signInRequest.setIpAddress(IPAddressUtil.getPublicIPAddress());
        signInRequest.setMacAddress(MACAddressUtil.getMacAddress());
        signInRequest.setCountry(Locale.getDefault().getDisplayCountry(Locale.ENGLISH));
        try {
            return new ObjectMapper().writeValueAsString((Object)signInRequest);
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    public static UserQuickDateDto fetchUserBetweenDates(LocalDate startDate, LocalDate endDate, ServerSettings serverSettings) throws IOException, InterruptedException {
        String url = serverSettings.getUrl() + "/user/between-dates?email=" + serverSettings.getEmail() + "&startDate=" + startDate + "&endDate=" + endDate;
        HttpResponse<String> response = ApiClient.sendGetRequest(url, serverSettings);
        ObjectMapper mapper = new ObjectMapper();
        return (UserQuickDateDto)mapper.readValue(response.body(), UserQuickDateDto.class);
    }

    public static UserActivityByDateAndProjectDto fetchUserActivityByProjects(ServerSettings serverSettings, LocalDate date, String ... projectNames) throws IOException, InterruptedException {
        String url = serverSettings.getUrl() + "/user/by-projects/by-date?email=" + serverSettings.getEmail() + "&date=" + date + "&projectNames=" + String.join((CharSequence)",", projectNames);
        HttpResponse<String> response = ApiClient.sendGetRequest(url, serverSettings);
        ObjectMapper mapper = new ObjectMapper();
        return (UserActivityByDateAndProjectDto)mapper.readValue(response.body(), UserActivityByDateAndProjectDto.class);
    }

    public static Map<String, PanDevStatusbarWidget.ModuleStatus.Status> isProjectsBelongsToCompany(ServerSettings serverSettings, MultiValueMap modulesPaths) throws IOException, InterruptedException, HttpException {
        String joinedProjectNames = String.join((CharSequence)",", modulesPaths.keySet());
        String url = serverSettings.getUrl() + "/is-project-belongs?projectNames=" + joinedProjectNames;
        HttpResponse<String> response = ApiClient.sendGetRequest(url, serverSettings);
        if (response.statusCode() != 200) {
            throw new HttpException(EXCEPTION_MESSAGE + response.statusCode());
        }
        ObjectMapper objectMapper = new ObjectMapper();
        ProjectOwnershipStatusResponseDto ownershipStatusResponseDto = (ProjectOwnershipStatusResponseDto)objectMapper.readValue(response.body(), ProjectOwnershipStatusResponseDto.class);
        if (ownershipStatusResponseDto == null || ownershipStatusResponseDto.getProjects().isEmpty()) {
            throw new HttpException("Response from server is null or empty");
        }
        HashMap<String, PanDevStatusbarWidget.ModuleStatus.Status> result = new HashMap<String, PanDevStatusbarWidget.ModuleStatus.Status>();
        for (ProjectOwnershipStatus status : ownershipStatusResponseDto.getProjects()) {
            for (Object entry : modulesPaths.entrySet()) {
                Collection modules = (Collection)((Map.Entry)entry).getValue();
                for (String moduleName : modules) {
                    result.put(moduleName, status.isBelongs() ? PanDevStatusbarWidget.ModuleStatus.Status.ACTIVE : PanDevStatusbarWidget.ModuleStatus.Status.INACTIVE);
                }
            }
        }
        return result;
    }

    public static ServerSettingsDto getServerSettings(String baseUrl) {
        String url = baseUrl + "/server-settings";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().timeout(Duration.of(5L, ChronoUnit.SECONDS)).build();
        try {
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            ObjectMapper mapper = new ObjectMapper();
            return (ServerSettingsDto)mapper.readValue(response.body(), ServerSettingsDto.class);
        }
        catch (IOException | InterruptedException e) {
            PanDevMetrics.log.error("Error while fetching user activity by projects", (Throwable)e);
            return new ServerSettingsDto();
        }
    }

    private static String parseParams(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        return "?" + params.entrySet().stream().map(entry -> URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
    }

    public static PluginVersionInfoDto getLatestVersionOfPluginFromMetricsServer(String url) {
        try {
            PanDevMetrics.log.info("Sending request to URL: {}", (Object)url);
            if (Objects.isNull(url) || url.isBlank()) {
                throw new IllegalArgumentException("URL is null or blank");
            }
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IOException(EXCEPTION_MESSAGE + response.statusCode());
            }
            ObjectMapper objectMapper = new ObjectMapper();
            return (PluginVersionInfoDto)objectMapper.readValue(response.body(), PluginVersionInfoDto.class);
        }
        catch (InterruptedException e) {
            PanDevMetrics.log.error("Thread was interrupted while fetching plugin version : message - {}, class - {}", (Object)e.getMessage(), (Object)e.getClass().getName());
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            PanDevMetrics.log.error("Unexpected error while fetching plugin version : message - {}, class - {}", (Object)e.getMessage(), (Object)e.getClass().getName());
        }
        catch (Exception e) {
            PanDevMetrics.log.error("Unexpected error : message - {}, class - {}", (Object)e.getMessage(), (Object)e.getClass().getName());
        }
        return null;
    }

    public static void getLatestPluginFromMetricsServer(final String fullUrl) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Downloading plugin", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                PluginUtils.createDownloadTask(fullUrl).run(indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "kz/pandev/plugins/metrics/clients/ApiClient$1", "run"));
            }
        });
    }
}

