/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.configs;

import java.io.File;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kz.pandev.plugins.metrics.configs.AuthenticationType;
import kz.pandev.plugins.metrics.models.Heartbeat;
import kz.pandev.plugins.metrics.models.events.DatasourceEvent;

public interface ServerSettings {
    public static final String FILE_NAME_PREFIX = "_pandev_metrics.cfg";
    public static final String INTERNAL_FILE_NAME_PREFIX = "_pandev_metrics_internal.cfg";
    public static final String QUEUE_FILE_NAME_PREFIX = "_queue.json";
    public static final String SETTINGS_SECTION = "settings";
    public static final String HOME_ENV = "PANDEV_METRICS_HOME";
    public static final String DEBUG_KEY = "debug";
    public static final String STATUS_BAR_ENABLED_KEY = "status_bar_enabled";
    public static final String GIT_KEY = "git";

    public void saveAllSettings(String var1, Map<String, String> var2);

    public String getSettings(String var1, String var2);

    public Queue<Heartbeat> getHeartbeatsQueue();

    public File getConfigFile(boolean var1);

    public File getQueueFile(boolean var1);

    public File getDbQueueFile(boolean var1);

    public File getExceptionQueueFile(boolean var1);

    public Queue<DatasourceEvent> getEventDbQueue();

    public String getDomain();

    public boolean isConfigured();

    public String getUrl();

    public AuthenticationType getAuthenticationType();

    public String getServerZoneId();

    public String getEmail();

    public String getVisualizationUrl();

    public String getAuthenticationHeader();

    public boolean isStatusBarEnabled();

    public static String getDomainInUrl(String url) {
        String regex = "^(?:https?://)?(?:www\\.)?([^:/]+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return url;
    }

    public boolean isGitEnabled();
}

