/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.exception;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.models.UnhandledPluginExceptionDto;
import kz.pandev.plugins.metrics.utils.EncryptionUtil;
import kz.pandev.plugins.metrics.utils.JsonUtils;

public class ExceptionFileActionManager {
    private ExceptionFileActionManager() {
        throw new UnsupportedOperationException("ExceptionFileActionManager class cannot be instantiated! - UtilityClass");
    }

    public static void addJsonObjectToFile(File file, List<UnhandledPluginExceptionDto> unhandledPluginExceptionDtos) {
        if (file == null || unhandledPluginExceptionDtos == null) {
            throw new IllegalArgumentException("File or unhandledPluginExceptionDTOs[] list is null");
        }
        try {
            List<UnhandledPluginExceptionDto> existingObjects = ExceptionFileActionManager.readObjectsFromFile(file);
            existingObjects.addAll(unhandledPluginExceptionDtos);
            ExceptionFileActionManager.writeObjectsToFile(existingObjects, file);
        }
        catch (IOException e) {
            PanDevMetrics.log.error("Failed to add JSON object to file: {}", (Object)file.getAbsoluteFile(), (Object)e);
        }
    }

    public static List<UnhandledPluginExceptionDto> readObjectsFromFile(File file) throws IOException {
        ArrayList<UnhandledPluginExceptionDto> existingObjects = new ArrayList<UnhandledPluginExceptionDto>();
        if (file.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                char[] buffer = new char[(int)file.length()];
                reader.read(buffer);
                String encryptedJson = new String(buffer);
                String decryptedJson = EncryptionUtil.decrypt(encryptedJson);
                UnhandledPluginExceptionDto[] objectsArray = (UnhandledPluginExceptionDto[])JsonUtils.GSON.fromJson(decryptedJson, UnhandledPluginExceptionDto[].class);
                if (objectsArray != null) {
                    Collections.addAll(existingObjects, objectsArray);
                }
            }
            catch (Exception e) {
                throw new IOException("Error while decrypting data", e);
            }
        }
        return existingObjects;
    }

    public static void writeObjectsToFile(List<UnhandledPluginExceptionDto> unhandledPluginExceptionDtos, File file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            String json = JsonUtils.GSON.toJson(unhandledPluginExceptionDtos);
            String encryptedJson = EncryptionUtil.encrypt(json);
            writer.write(encryptedJson);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

