/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.git.watcher;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.clients.ApiClient;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.factory.ServerSettingsFactory;
import kz.pandev.plugins.metrics.models.CommitRequestDto;
import kz.pandev.plugins.metrics.utils.EncryptionUtil;
import kz.pandev.plugins.metrics.utils.JsonUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class GitCommitWatcher
implements Disposable {
    private WatchService watchService;
    private String lastKnownCommit;
    private boolean running = true;
    private final Project project;
    private final Disposable disposable;
    private final Path gitLogPath;
    private final String projectBasePath;
    private final String projectName;
    private static final String NO_COMMIT = "NO_COMMIT";
    private static final String GIT_LOG_PATH = "/.git/logs/HEAD";

    public GitCommitWatcher(Project project) {
        this.project = project;
        this.disposable = Disposer.newDisposable();
        this.projectBasePath = project.getBasePath();
        this.projectName = project.getName();
        this.gitLogPath = Paths.get(this.projectBasePath + GIT_LOG_PATH, new String[0]);
        this.lastKnownCommit = this.loadLastCommit();
        PanDevMetrics.log.info("GitWatcher initialized for project: {}", (Object)this.projectName);
        project.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                PanDevMetrics.log.info("Project closed: {}", (Object)project.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "kz/pandev/plugins/metrics/git/watcher/GitCommitWatcher$1", "projectClosed"));
            }
        });
        this.startWatchingGitLogs();
    }

    private void startWatchingGitLogs() {
        int maxRetries = 3;
        int retryCount = 0;
        while (retryCount < maxRetries) {
            try {
                this.initializeWatchService();
                this.startWatchThread();
                PanDevMetrics.log.info("WatchService started for project: {}", (Object)this.projectName);
                return;
            }
            catch (IOException e) {
                PanDevMetrics.log.error("Attempt {}/{}: Failed to start WatchService for project {}: message - {}, class - {}", (Object)(++retryCount), (Object)maxRetries, (Object)this.projectName, (Object)e.getMessage(), (Object)e.getClass().getSimpleName());
                if (retryCount >= maxRetries) continue;
                long delay = (long)Math.pow(2.0, retryCount) * 1000L;
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    PanDevMetrics.log.error("Thread interrupted during sleep between retries: message - {}, class- {}", (Object)ie.getMessage(), (Object)ie.getClass().getName());
                    return;
                }
            }
        }
        PanDevMetrics.log.error("Failed to start WatchService for Git log file in project {} after {} attempts", (Object)this.projectName, (Object)maxRetries);
    }

    private void initializeWatchService() throws IOException {
        if (this.watchService != null) {
            this.watchService.close();
        }
        this.watchService = FileSystems.getDefault().newWatchService();
        Path parentDir = this.gitLogPath.getParent();
        parentDir.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    private void startWatchThread() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            while (this.running) {
                try {
                    this.processWatchKey(this.watchService.take());
                }
                catch (InterruptedException e) {
                    PanDevMetrics.log.error("WatchService interrupted: message - {}, class - {}", (Object)e.getMessage(), (Object)e.getClass().getName());
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (ClosedWatchServiceException e) {
                    PanDevMetrics.log.warn("WatchService closed unexpectedly, restarting...");
                    this.startWatchingGitLogs();
                    break;
                }
            }
        });
    }

    private void processWatchKey(WatchKey key) {
        for (WatchEvent<?> event : key.pollEvents()) {
            Path modifiedFile;
            if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY || !(modifiedFile = (Path)event.context()).equals(this.gitLogPath.getFileName())) continue;
            PanDevMetrics.log.info("Detected changes in Git log file for project: {}", (Object)this.projectName);
            this.checkForNewCommits();
        }
        key.reset();
    }

    private void checkForNewCommits() {
        ApplicationManager.getApplication().runReadAction(() -> {
            try (Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(new File(this.projectBasePath, ".git"))).readEnvironment()).findGitDir()).build();
                 Git git = new Git(repository);){
                RevCommit latestCommit;
                String commitHash;
                Iterator logIterator = git.log().setMaxCount(1).call().iterator();
                if (logIterator.hasNext() && !Objects.equals(commitHash = (latestCommit = (RevCommit)logIterator.next()).getName(), this.lastKnownCommit)) {
                    this.lastKnownCommit = commitHash;
                    this.handleNewCommit(latestCommit, repository.getBranch());
                    this.saveLastCommit(this.lastKnownCommit);
                }
            }
            catch (Exception e) {
                PanDevMetrics.log.error("Exception while checking for new commits in project {}: message- {}, class - {}", (Object)this.projectName, (Object)e.getMessage(), (Object)e.getClass().getSimpleName());
            }
        });
    }

    public void stopWatchingGitLogs() {
        this.running = false;
        try {
            if (this.watchService != null) {
                this.watchService.close();
            }
        }
        catch (IOException e) {
            PanDevMetrics.log.error("Error closing WatchService: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void saveLastCommit(String commitHash) {
        PanDevMetrics.log.info("Saving last commit to Git log in project {}: {}", (Object)this.projectName, (Object)commitHash);
        PropertiesComponent.getInstance((Project)this.project).setValue(this.getProjectSpecificKey(), commitHash);
    }

    private String loadLastCommit() {
        String lastCommit = PropertiesComponent.getInstance((Project)this.project).getValue(this.getProjectSpecificKey(), NO_COMMIT);
        PanDevMetrics.log.info("Last commit from Git log for project {}: {}", (Object)this.projectName, (Object)lastCommit);
        return lastCommit;
    }

    private String getProjectSpecificKey() {
        String projectPath = this.projectBasePath;
        return "lastKnownCommit:" + (projectPath != null ? Base64.getEncoder().encodeToString(projectPath.getBytes()) : "default");
    }

    public void dispose() {
        this.stopWatchingGitLogs();
        Disposer.dispose((Disposable)this.disposable);
    }

    private void handleNewCommit(RevCommit commit, String branch) {
        PanDevMetrics.log.info("Processing new commit for project {} branch {}", (Object)this.projectName, (Object)branch);
        CommitRequestDto commitRequestDto = new CommitRequestDto();
        commitRequestDto.setTimestamp(BigDecimal.valueOf(commit.getCommitTime()));
        commitRequestDto.setHash(commit.getName());
        commitRequestDto.setParentHash(commit.getParentCount() > 0 ? commit.getParent(0).getName() : null);
        commitRequestDto.setGitProjectName(this.projectName);
        commitRequestDto.setGitBranch(branch);
        commitRequestDto.setAuthor(commit.getAuthorIdent().getName());
        commitRequestDto.setMessage(commit.getShortMessage());
        String encryptedJson = null;
        try {
            encryptedJson = EncryptionUtil.encrypt(JsonUtils.GSON.toJson(Collections.singletonList(commitRequestDto)));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            PanDevMetrics.log.error("Exception while encrypting commit for branch {} in project {}: message - {}, class - {}", (Object)branch, (Object)this.projectName, (Object)e.getMessage(), (Object)e.getClass().getSimpleName());
        }
        for (ServerSettings serverSetting : ServerSettingsFactory.getAllServerSettings()) {
            try {
                ApiClient.sendJsonStringToServer(serverSetting, encryptedJson, "/worklog/commit");
            }
            catch (Exception e) {
                PanDevMetrics.log.error("Exception while sending commit for branch {} in project {}: message - {},class - {}", (Object)branch, (Object)this.projectName, (Object)e.getMessage(), (Object)e.getClass().getSimpleName());
            }
        }
    }
}

