/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.ui_dialogs;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kz.pandev.plugins.metrics.clients.ApiClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdatePluginDialog
extends DialogWrapper {
    private final String url;

    public UpdatePluginDialog(String url) {
        super(true);
        this.url = url;
        this.setTitle("New version available");
        this.setResizable(false);
        this.init();
        this.pack();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder((Border)JBUI.Borders.empty());
        mainPanel.setBackground(JBColor.PanelBackground);
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.insets = JBUI.insets((int)10, (int)0);
        JLabel iconLabel = new JLabel();
        Icon icon = IconLoader.getIcon((String)("images/icons/logo-" + (JBColor.isBright() ? "light" : "dark") + "-theme-small.png"), UpdatePluginDialog.class);
        iconLabel.setIcon(icon);
        contentPanel.add((Component)iconLabel, gbc);
        JLabel titleLabel = new JLabel("New version of PanDev Metrics plugin is available");
        titleLabel.setFont((Font)JBUI.Fonts.label().asBold());
        titleLabel.setForeground(JBColor.foreground());
        contentPanel.add((Component)titleLabel, gbc);
        JButton installButton = new JButton("Install");
        installButton.setPreferredSize(null);
        installButton.setDefaultCapable(true);
        installButton.putClientProperty("JButton.buttonType", "default");
        installButton.addActionListener(e -> {
            ApiClient.getLatestPluginFromMetricsServer(this.url);
            this.close(0);
        });
        contentPanel.add((Component)installButton, gbc);
        mainPanel.add((Component)contentPanel, "Center");
        mainPanel.setMinimumSize(new Dimension(320, 200));
        mainPanel.setMaximumSize(new Dimension(320, 200));
        return mainPanel;
    }

    protected Action @NotNull [] createActions() {
        return new Action[0];
    }
}

