/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.utils;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kz.pandev.plugins.metrics.PanDevMetrics;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;

public final class GitInfoProvider {
    private static final String CHECKER_IS_GIT_FILE = "\\.git$";

    private GitInfoProvider() {
    }

    public static String[] getGitBranch(String path) {
        File projectDirectory = new File(Objects.requireNonNull(path));
        File gitFolder = GitInfoProvider.findGitFolder(projectDirectory);
        if (gitFolder != null) {
            String repositoryName = GitInfoProvider.getRepositoryPath(gitFolder);
            String branchName = GitInfoProvider.getCurrentBranch(gitFolder);
            return new String[]{repositoryName, branchName};
        }
        return new String[0];
    }

    public static File findGitFolder(File directory) {
        PanDevMetrics.log.info("Looking for directory: {}", (Object)directory);
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || !".git".equals(file.getName())) continue;
                PanDevMetrics.log.info("Found directory: {}", (Object)file);
                return file;
            }
        }
        return null;
    }

    public static String getRepositoryPath(File gitFolder) {
        File configFile = new File(gitFolder, "config");
        if (configFile.exists()) {
            try {
                String configContent = Files.readString(configFile.toPath());
                Pattern pattern = Pattern.compile("\\[remote \"origin\"\\]\\s+url = (.+)");
                Matcher matcher = pattern.matcher(configContent);
                if (matcher.find()) {
                    String remoteUrl = matcher.group(1);
                    return GitInfoProvider.extractRepositoryPath(remoteUrl);
                }
            }
            catch (IOException e) {
                PanDevMetrics.log.error(e.getMessage());
            }
        }
        return null;
    }

    private static String extractRepositoryPath(String remoteUrl) {
        if (remoteUrl.startsWith("git@")) {
            return remoteUrl.replaceFirst("git@[^:]+:", "").replaceFirst(CHECKER_IS_GIT_FILE, "");
        }
        if (remoteUrl.startsWith("https://")) {
            return remoteUrl.replaceFirst("https://[^/]+/", "").replaceFirst(CHECKER_IS_GIT_FILE, "");
        }
        if (remoteUrl.startsWith("http://")) {
            return remoteUrl.replaceFirst("http://[^/]+/", "").replaceFirst(CHECKER_IS_GIT_FILE, "");
        }
        if (remoteUrl.startsWith("ssh://")) {
            return remoteUrl.replaceFirst("ssh://[^/]+/", "").replaceFirst(CHECKER_IS_GIT_FILE, "");
        }
        return null;
    }

    public static String getCurrentBranch(File gitFolder) {
        String string;
        block8: {
            Repository repository = ((RepositoryBuilder)new RepositoryBuilder().setGitDir(gitFolder)).build();
            try {
                string = repository.getBranch();
                if (repository == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    PanDevMetrics.log.error(e.getMessage());
                    return null;
                }
            }
            repository.close();
        }
        return string;
    }

    public static String getModuleGitRepositoryName(Module module) {
        VirtualFile virtualModuleFile = ProjectUtil.guessModuleDir((Module)module);
        if (virtualModuleFile == null) {
            PanDevMetrics.log.info("Virtual module not found: {}", (Object)module);
            return null;
        }
        File moduleGitFile = GitInfoProvider.findGitFolder(new File(virtualModuleFile.getPath()));
        if (moduleGitFile == null) {
            PanDevMetrics.log.info("Module Git File not found: {}", (Object)virtualModuleFile);
            return null;
        }
        return GitInfoProvider.getRepositoryPath(moduleGitFile);
    }

    public static String getModuleGitBranch(Module module) {
        VirtualFile virtualModuleFile = ProjectUtil.guessModuleDir((Module)module);
        if (virtualModuleFile == null) {
            return null;
        }
        File moduleGitFile = GitInfoProvider.findGitFolder(new File(virtualModuleFile.getPath()));
        if (moduleGitFile == null) {
            return null;
        }
        return GitInfoProvider.getCurrentBranch(moduleGitFile);
    }
}

