/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.utils;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.clients.ApiClient;
import kz.pandev.plugins.metrics.models.PluginVersionInfoDto;
import kz.pandev.plugins.metrics.ui_dialogs.UpdatePluginDialog;

public class PluginUtils {
    private static final String VERSION_PATTERN = "(\\d{1,4}\\.\\d{1,3}\\.\\d{1,3})";
    private static UpdatePluginDialog updatePluginDialog;

    private PluginUtils() {
    }

    public static void checkForUpdates(String url) {
        String baseUrl = url.concat("/v1/jetbrains-plugin");
        String currentVersion = PanDevMetrics.VERSION;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                String serverVersion;
                PluginVersionInfoDto serverVersionInfo = ApiClient.getLatestVersionOfPluginFromMetricsServer(baseUrl.concat("/version"));
                if (serverVersionInfo != null && serverVersionInfo.getVersion() != null && (serverVersion = PluginUtils.extractVersion(serverVersionInfo.getVersion())) != null && PluginUtils.compareVersions(serverVersion, currentVersion) > 0) {
                    PluginUtils.showUpdateDialog(baseUrl.concat("/download"));
                }
            }
            catch (Exception e) {
                PanDevMetrics.log.error("Unexpected error : message - {}, class - {}", (Object)e.getMessage(), (Object)e.getClass().getName());
            }
        });
    }

    public static int compareVersions(String versionFromServer, String currentPluginVersion) {
        String[] parts1 = versionFromServer.split("\\.");
        String[] parts2 = currentPluginVersion.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (num1 == num2) continue;
            return Integer.compare(num1, num2);
        }
        return 0;
    }

    private static void showUpdateDialog(String downloadUrl) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (updatePluginDialog == null || !updatePluginDialog.isVisible()) {
                updatePluginDialog = new UpdatePluginDialog(downloadUrl);
                updatePluginDialog.show();
            }
        });
    }

    public static Progressive createDownloadTask(String downloadUrl) {
        return indicator -> {
            HttpURLConnection connection = null;
            try {
                connection = PluginUtils.createDownloadConnection(downloadUrl);
                PluginUtils.handleFileDownload(connection, indicator);
                PluginUtils.promptForRestart();
            }
            catch (Exception e) {
                PluginUtils.showErrorDialog("Failed to download plugin update: " + e.getMessage());
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        };
    }

    private static HttpURLConnection createDownloadConnection(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(60000);
        connection.setInstanceFollowRedirects(true);
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.connect();
        return connection;
    }

    private static void handleFileDownload(HttpURLConnection urlConnection, ProgressIndicator indicator) throws IOException {
        int fileSize = urlConnection.getContentLength();
        indicator.setIndeterminate(fileSize == -1);
        Path zipPath = Path.of(PathManager.getPluginsPath(), "plugin.zip");
        try (InputStream inputStream = urlConnection.getInputStream();
             OutputStream outputStream = Files.newOutputStream(zipPath, new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[16384];
            long totalBytesRead = 0L;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                PluginUtils.updateProgress(indicator, fileSize, totalBytesRead += (long)bytesRead);
                if (!indicator.isIndeterminate()) {
                    indicator.setFraction((double)totalBytesRead / (double)fileSize);
                }
                if (!indicator.isCanceled()) continue;
                throw new InterruptedIOException("Download canceled by user");
            }
        }
        PluginUtils.installWithRestart(zipPath, Path.of(PathManager.getPluginsPath(), new String[0]));
    }

    public static void installWithRestart(Path zipPath, Path pluginsPath) throws IOException {
        IdeaPluginDescriptor descriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"kz.pandev.intellij.plugin"));
        if (descriptor == null) {
            throw new IOException("Can't load plugin descriptor");
        }
        Path targetPath = Paths.get(pluginsPath.toString(), "pandev-metrics-plugin");
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                PluginInstaller.installAfterRestart((IdeaPluginDescriptor)descriptor, (Path)zipPath, (Path)targetPath, (boolean)true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void updateProgress(ProgressIndicator indicator, int fileSize, long totalBytesRead) {
        if (fileSize > 0) {
            double progress = (double)totalBytesRead / (double)fileSize;
            indicator.setFraction(progress);
            indicator.setText("Downloading ... " + (int)(progress * 100.0) + "%");
        }
    }

    private static void promptForRestart() {
        ApplicationManager.getApplication().invokeLater(() -> {
            int result = Messages.showYesNoDialog((String)"Plugin update installed successfully. Restart IDE to apply changes?", (String)"Restart Required", (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                ApplicationManager.getApplication().restart();
            }
        });
    }

    private static void showErrorDialog(String message) {
        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)message, (String)"Plugin Update Error"));
    }

    public static String extractVersion(String version) {
        Matcher matcher = Pattern.compile(VERSION_PATTERN).matcher(version);
        return matcher.find() ? matcher.group(1) : null;
    }
}

