/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.utils;

import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class TimeConverterUtils {
    private TimeConverterUtils() {
    }

    public static long convertDateStringToSeconds(String timeString) {
        String[] parts = timeString.split(":");
        long hours = Long.parseLong(parts[0]);
        long minutes = Long.parseLong(parts[1]);
        long seconds = Long.parseLong(parts[2]);
        return hours * 3600L + minutes * 60L + seconds;
    }

    @NotNull
    public static String getTimeAsString(String totalTimeSpent) {
        String[] totalTimeSpentArray = totalTimeSpent.split(":");
        long totalHour = totalTimeSpentArray.length > 0 ? Long.parseLong(totalTimeSpentArray[0]) : 0L;
        long totalMinutes = totalTimeSpentArray.length > 1 ? Long.parseLong(totalTimeSpentArray[1]) : 0L;
        long totalSeconds = totalTimeSpentArray.length > 2 ? Long.parseLong(totalTimeSpentArray[2]) : 0L;
        return TimeConverterUtils.getTimeAsString(totalHour, totalMinutes, totalSeconds);
    }

    public static String getTimeAsString(long totalSeconds) {
        Duration duration = Duration.ofSeconds(totalSeconds);
        long hours = duration.toHours();
        long minutes = duration.toMinutesPart();
        long seconds = duration.toSecondsPart();
        return TimeConverterUtils.getTimeAsString(hours, minutes, seconds);
    }

    @NotNull
    private static String getTimeAsString(long totalHour, long totalMinutes, long totalSeconds) {
        String totalTimeStem;
        if (totalHour <= 0L) {
            totalTimeStem = totalMinutes <= 0L ? totalSeconds + " s" : totalMinutes + " m";
        } else {
            totalTimeStem = totalHour + " h";
            if (totalMinutes > 0L) {
                totalTimeStem = totalTimeStem + " " + totalMinutes + " m";
            }
        }
        String string = totalTimeStem.trim();
        if (string == null) {
            TimeConverterUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kz/pandev/plugins/metrics/utils/TimeConverterUtils", "getTimeAsString"));
    }
}

