/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.widgets;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.clients.ApiClient;
import kz.pandev.plugins.metrics.configs.ServerSettings;
import kz.pandev.plugins.metrics.factory.ServerSettingsFactory;
import kz.pandev.plugins.metrics.models.ProjectActivityDto;
import kz.pandev.plugins.metrics.models.UserActivityByDateAndProjectDto;
import kz.pandev.plugins.metrics.models.UserQuickDateDto;
import kz.pandev.plugins.metrics.ui_dialogs.AbstractSettingsView;
import kz.pandev.plugins.metrics.utils.GitInfoProvider;
import kz.pandev.plugins.metrics.utils.TimeConverterUtils;
import kz.pandev.plugins.metrics.widgets.PanDevStatusBarFactory;
import org.apache.commons.collections.map.MultiValueMap;
import org.jetbrains.annotations.NotNull;

public class PanDevStatusbarWidget
implements CustomStatusBarWidget {
    public static final String WIDGET_ID = "PanDevStatusbarWidget";
    private final Project project;
    private final JLabel textLabel;
    private final JLabel logoLabel;
    private final JLabel statusBarIconLabel;
    private JPanel panel;
    private final String domain;
    private final Map<String, ModuleStatus> projectStatusIconMap = new HashMap<String, ModuleStatus>();

    public PanDevStatusbarWidget(Project project, String domain) {
        this.project = project;
        this.domain = domain;
        this.logoLabel = new JLabel(PanDevMetrics.getLogoIcon());
        this.textLabel = new JLabel("Loading");
        this.statusBarIconLabel = new JLabel(PanDevStatusBarFactory.LOADING_ICON);
    }

    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.add(this.logoLabel);
            this.panel.add(this.statusBarIconLabel);
            this.panel.add(this.textLabel);
            this.panel.setToolTipText("loading");
            final Color backgroundColor = JBUI.CurrentTheme.StatusBar.BACKGROUND;
            final Color hoverColor = JBUI.CurrentTheme.StatusBar.Widget.HOVER_BACKGROUND;
            this.panel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    PanDevMetrics.openDashboardWebsite(ServerSettingsFactory.getServerSettingsByDomain(PanDevStatusbarWidget.this.domain).getVisualizationUrl());
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    PanDevStatusbarWidget.this.panel.setBackground(hoverColor);
                    super.mouseEntered(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PanDevStatusbarWidget.this.panel.setBackground(backgroundColor);
                    super.mouseExited(e);
                }
            });
        }
        return this.panel;
    }

    public void refresh(ServerSettings serverSettings) {
        if (serverSettings == null) {
            return;
        }
        this.updateModulesStatusIcon(this.project, serverSettings);
        this.refreshTodayTextActivity(serverSettings);
        this.updateModuleActivityText(serverSettings);
        this.setToolText(serverSettings);
    }

    private void refreshTodayTextActivity(ServerSettings serverSettings) {
        try {
            UserQuickDateDto userQuickDateDto = ApiClient.fetchUserBetweenDates(LocalDate.now(ZoneId.of(serverSettings.getServerZoneId())), LocalDate.now(ZoneId.of(serverSettings.getServerZoneId())), serverSettings);
            String todayTimeActivityText = TimeConverterUtils.getTimeAsString(userQuickDateDto.getTotalTimeSpent());
            this.textLabel.setText(todayTimeActivityText);
            PanDevMetrics.log.debug("Updating status bar text to {}", (Object)todayTimeActivityText);
        }
        catch (IOException | InterruptedException e) {
            PanDevMetrics.log.error("An error occurred while updating the time counter for today : message - {}, class - {}", (Object)e.getMessage(), (Object)e.getClass().getName());
            this.textLabel.setText(e.getMessage());
            this.statusBarIconLabel.setIcon(PanDevStatusBarFactory.SERVER_INACTIVE_ICON);
        }
    }

    private void updateModulesStatusIcon(Project project, ServerSettings serverSettings) {
        HashSet<String> modulesToUpdateStatusIcon = new HashSet<String>();
        Module[] modules = ModuleManager.getInstance((Project)project).getSortedModules();
        String projectName = modules.length > 0 ? modules[0].getName() : project.getName();
        MultiValueMap modulesPaths = new MultiValueMap();
        for (Module module : modules) {
            modulesToUpdateStatusIcon.add(module.getName());
            modulesPaths.put((Object)GitInfoProvider.getModuleGitRepositoryName(module), (Object)module.getName());
        }
        this.projectStatusIconMap.keySet().removeIf(name -> !modulesToUpdateStatusIcon.contains(name));
        this.updateModuleStatusIcon(serverSettings, modulesPaths);
        this.statusBarIconLabel.setIcon(PanDevStatusbarWidget.getProjectStatusIconByStatus(this.projectStatusIconMap.get((Object)projectName).status));
    }

    private void updateModuleActivityText(ServerSettings serverSettings) {
        UserActivityByDateAndProjectDto modulesActivities = PanDevMetrics.fetchTodayModulesActivity(serverSettings, (String[])this.projectStatusIconMap.keySet().toArray(String[]::new));
        if (modulesActivities != null) {
            List<ProjectActivityDto> projectActivityDtoList = modulesActivities.getProjects();
            HashMap<String, Long> timeSpentInProjectMap = new HashMap<String, Long>();
            for (ProjectActivityDto projectActivity : projectActivityDtoList) {
                String projectKey = projectActivity.getModuleName();
                timeSpentInProjectMap.put(projectKey, timeSpentInProjectMap.getOrDefault(projectKey, 0L) + TimeConverterUtils.convertDateStringToSeconds(projectActivity.getTimeSpent()));
            }
            timeSpentInProjectMap.forEach((k, v) -> {
                ModuleStatus moduleStatus = this.projectStatusIconMap.get(k);
                if (moduleStatus != null && moduleStatus.status.equals((Object)ModuleStatus.Status.ACTIVE)) {
                    moduleStatus.setProjectActivity(TimeConverterUtils.getTimeAsString(v));
                }
            });
        }
    }

    private void updateModuleStatusIcon(ServerSettings serverSettings, MultiValueMap modulesPaths) {
        Map<String, ModuleStatus.Status> modulStatusesMap = PanDevMetrics.fetchTodayStatusIcon(serverSettings, modulesPaths);
        String currentModuleActivity = "0 sec";
        for (Map.Entry<String, ModuleStatus.Status> entry : modulStatusesMap.entrySet()) {
            this.projectStatusIconMap.put(entry.getKey(), new ModuleStatus(entry.getValue(), currentModuleActivity));
        }
    }

    private void setToolText(ServerSettings serverSettings) {
        String serverName = serverSettings.getDomain();
        ClassLoader classLoader = AbstractSettingsView.class.getClassLoader();
        Font defaultFont = JBUI.CurrentTheme.StatusBar.font();
        String fontCss = "font-family: '" + defaultFont.getFamily() + "'; font-size: " + defaultFont.getSize() + "pt;";
        StringBuilder htmlContent = new StringBuilder("<html><body style='" + fontCss + "'>");
        htmlContent.append("<h3>").append(serverName).append("</h3>");
        for (Map.Entry<String, ModuleStatus> entry : this.projectStatusIconMap.entrySet()) {
            URL iconUrl;
            htmlContent.append(entry.getKey()).append(" :  ");
            ModuleStatus moduleStatus = entry.getValue();
            htmlContent.append(moduleStatus.projectActivity).append("  -  ");
            if ((iconUrl = classLoader.getResource(switch (moduleStatus.getStatus()) {
                case ModuleStatus.Status.ACTIVE -> "images/status_icons/green.png";
                case ModuleStatus.Status.INACTIVE -> "images/status_icons/red.png";
                default -> "images/status_icons/yellow.png";
            })) == null) continue;
            htmlContent.append("<img src='").append(iconUrl).append("'<br><br>");
        }
        htmlContent.delete(htmlContent.length() - 8, htmlContent.length());
        htmlContent.append("</html");
        this.panel.setToolTipText(htmlContent.toString());
    }

    public static Icon getProjectStatusIconByStatus(ModuleStatus.Status status) {
        return switch (status) {
            case ModuleStatus.Status.ACTIVE -> PanDevStatusBarFactory.ACTIVE_PROJECT_ICON;
            case ModuleStatus.Status.INACTIVE -> PanDevStatusBarFactory.INACTIVE_PROJECT_ICON;
            default -> PanDevStatusBarFactory.SERVER_INACTIVE_ICON;
        };
    }

    @NotNull
    public String ID() {
        String string = this.domain;
        if (string == null) {
            PanDevStatusbarWidget.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kz/pandev/plugins/metrics/widgets/PanDevStatusbarWidget", "ID"));
    }

    public static class ModuleStatus {
        private Status status;
        private String projectActivity;

        public ModuleStatus(Status status, String projectActivity) {
            this.status = status;
            this.projectActivity = projectActivity;
        }

        public ModuleStatus() {
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public String getProjectActivity() {
            return this.projectActivity;
        }

        public void setProjectActivity(String projectActivity) {
            this.projectActivity = projectActivity;
        }

        public static enum Status {
            ACTIVE,
            INACTIVE,
            ISSUES;

        }
    }
}

