/*
 * Decompiled with CFR 0.152.
 */
package kz.pandev.plugins.metrics.d.a;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import kz.pandev.plugins.metrics.PanDevMetrics;
import kz.pandev.plugins.metrics.a.d;
import kz.pandev.plugins.metrics.c.b;
import kz.pandev.plugins.metrics.clients.ApiClient;
import kz.pandev.plugins.metrics.f.f;
import kz.pandev.plugins.metrics.models.CommitRequestDto;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class a
implements Disposable {
    private WatchService a;
    private String b;
    private boolean c = true;
    private final Project d;
    private final Disposable e;
    private final Path f;
    private final String g;
    private final String h;
    private static final String i = "NO_COMMIT";
    private static final String j = "/.git/logs/HEAD";

    public a(Project project) {
        this.d = project;
        this.e = Disposer.newDisposable();
        this.g = project.getBasePath();
        this.h = project.getName();
        this.f = Paths.get(this.g + j, new String[0]);
        this.b = this.f();
        PanDevMetrics.log.info("GitWatcher initialized for project: {}", (Object)this.h);
        project.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.a(0);
                }
                PanDevMetrics.log.info("Project closed: {}", (Object)project.getName());
            }

            private static /* synthetic */ void a(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "kz/pandev/plugins/metrics/git/watcher/GitCommitWatcher$1", "projectClosed"));
            }
        });
        this.b();
    }

    private void b() {
        int n = 3;
        int n2 = 0;
        while (n2 < n) {
            try {
                this.c();
                this.d();
                PanDevMetrics.log.info("WatchService started for project: {}", (Object)this.h);
                return;
            }
            catch (IOException iOException) {
                PanDevMetrics.log.error("Attempt {}/{}: Failed to start WatchService for project {}: message - {}, class - {}", (Object)(++n2), (Object)n, (Object)this.h, (Object)iOException.getMessage(), (Object)iOException.getClass().getSimpleName());
                if (n2 >= n) continue;
                long l = (long)Math.pow(2.0, n2) * 1000L;
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    PanDevMetrics.log.error("Thread interrupted during sleep between retries: message - {}, class- {}", (Object)interruptedException.getMessage(), (Object)interruptedException.getClass().getName());
                    return;
                }
            }
        }
        PanDevMetrics.log.error("Failed to start WatchService for Git log file in project {} after {} attempts", (Object)this.h, (Object)n);
    }

    private void c() throws IOException {
        if (this.a != null) {
            this.a.close();
        }
        this.a = FileSystems.getDefault().newWatchService();
        Path path = this.f.getParent();
        path.register(this.a, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    private void d() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            while (this.c) {
                try {
                    this.a(this.a.take());
                }
                catch (InterruptedException interruptedException) {
                    PanDevMetrics.log.error("WatchService interrupted: message - {}, class - {}", (Object)interruptedException.getMessage(), (Object)interruptedException.getClass().getName());
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (ClosedWatchServiceException closedWatchServiceException) {
                    PanDevMetrics.log.warn("WatchService closed unexpectedly, restarting...");
                    this.b();
                    break;
                }
            }
        });
    }

    private void a(WatchKey watchKey) {
        for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
            Path path;
            if (watchEvent.kind() != StandardWatchEventKinds.ENTRY_MODIFY || !(path = (Path)watchEvent.context()).equals(this.f.getFileName())) continue;
            PanDevMetrics.log.info("Detected changes in Git log file for project: {}", (Object)this.h);
            this.e();
        }
        watchKey.reset();
    }

    private void e() {
        ApplicationManager.getApplication().runReadAction(() -> {
            try (Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(new File(this.g, ".git"))).readEnvironment()).findGitDir()).build();
                 Git git = new Git(repository);){
                RevCommit revCommit;
                String string;
                Iterator iterator = git.log().setMaxCount(1).call().iterator();
                if (iterator.hasNext() && !Objects.equals(string = (revCommit = (RevCommit)iterator.next()).getName(), this.b)) {
                    this.b = string;
                    this.a(revCommit, repository.getBranch());
                    this.a(this.b);
                }
            }
            catch (Exception exception) {
                PanDevMetrics.log.error("Exception while checking for new commits in project {}: message- {}, class - {}", (Object)this.h, (Object)exception.getMessage(), (Object)exception.getClass().getSimpleName());
            }
        });
    }

    public void a() {
        this.c = false;
        try {
            if (this.a != null) {
                this.a.close();
            }
        }
        catch (IOException iOException) {
            PanDevMetrics.log.error("Error closing WatchService: {}", (Object)iOException.getMessage(), (Object)iOException);
        }
    }

    private void a(String string) {
        PanDevMetrics.log.info("Saving last commit to Git log in project {}: {}", (Object)this.h, (Object)string);
        PropertiesComponent.getInstance((Project)this.d).setValue(this.g(), string);
    }

    private String f() {
        String string = PropertiesComponent.getInstance((Project)this.d).getValue(this.g(), i);
        PanDevMetrics.log.info("Last commit from Git log for project {}: {}", (Object)this.h, (Object)string);
        return string;
    }

    private String g() {
        String string = this.g;
        return "lastKnownCommit:" + (string != null ? Base64.getEncoder().encodeToString(string.getBytes()) : "default");
    }

    public void dispose() {
        this.a();
        Disposer.dispose((Disposable)this.e);
    }

    private void a(RevCommit revCommit, String string) {
        PanDevMetrics.log.info("Processing new commit for project {} branch {}", (Object)this.h, (Object)string);
        CommitRequestDto commitRequestDto = new CommitRequestDto();
        commitRequestDto.setTimestamp(BigDecimal.valueOf(revCommit.getCommitTime()));
        commitRequestDto.setHash(revCommit.getName());
        commitRequestDto.setParentHash(revCommit.getParentCount() > 0 ? revCommit.getParent(0).getName() : null);
        commitRequestDto.setGitProjectName(this.h);
        commitRequestDto.setGitBranch(string);
        commitRequestDto.setAuthor(revCommit.getAuthorIdent().getName());
        commitRequestDto.setMessage(revCommit.getShortMessage());
        String string2 = null;
        try {
            string2 = kz.pandev.plugins.metrics.f.b.a(kz.pandev.plugins.metrics.f.f.a.toJson(Collections.singletonList(commitRequestDto)));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            PanDevMetrics.log.error("Exception while encrypting commit for branch {} in project {}: message - {}, class - {}", (Object)string, (Object)this.h, (Object)generalSecurityException.getMessage(), (Object)generalSecurityException.getClass().getSimpleName());
        }
        for (d d2 : kz.pandev.plugins.metrics.c.b.d()) {
            try {
                ApiClient.sendJsonStringToServer(d2, string2, "/worklog/commit");
            }
            catch (Exception exception) {
                PanDevMetrics.log.error("Exception while sending commit for branch {} in project {}: message - {},class - {}", (Object)string, (Object)this.h, (Object)exception.getMessage(), (Object)exception.getClass().getSimpleName());
            }
        }
    }
}

